/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.dest.metadata;

import edu.emory.cci.aiw.i2b2etl.dest.metadata.Concept;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.DataType;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.Metadata;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.OntologyBuildException;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.PropositionConceptTreeBuilder;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.SubtreeBuilder;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.UnknownPropositionDefinitionException;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.ConceptId;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.InvalidConceptCodeException;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.SimpleConceptId;
import java.util.HashSet;
import org.protempa.KnowledgeSourceCache;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.PropositionDefinition;

class PhenotypesBuilder
extends PropositionConceptTreeBuilder
implements SubtreeBuilder {
    private final String sourceSystemCode;
    private Concept concept;

    PhenotypesBuilder(KnowledgeSourceCache cache, Metadata metadata) throws KnowledgeSourceReadException, UnknownPropositionDefinitionException {
        super(cache, PhenotypesBuilder.phenotypePropIds(metadata), null, null, null, false, metadata);
        this.sourceSystemCode = metadata.getSourceSystemCode();
    }

    @Override
    public void build(Concept parent) throws OntologyBuildException {
        Metadata metadata = this.getMetadata();
        ConceptId conceptId = SimpleConceptId.getInstance("AIW|Phenotypes", metadata);
        this.concept = metadata.getFromIdCache(conceptId);
        if (this.concept == null) {
            try {
                this.concept = new Concept(conceptId, null, metadata);
            }
            catch (InvalidConceptCodeException ex) {
                throw new OntologyBuildException(ex);
            }
            this.concept.setSourceSystemCode(this.sourceSystemCode);
            this.concept.setDisplayName("Phenotypes");
            this.concept.setDataType(DataType.TEXT);
            this.concept.setAlreadyLoaded(false);
            metadata.addToIdCache(this.concept);
            if (parent != null) {
                parent.add(this.concept);
            }
        }
        super.build(this.concept);
    }

    @Override
    public Concept[] getRoots() {
        if (this.concept != null) {
            return new Concept[]{this.concept};
        }
        return EMPTY_CONCEPT_ARRAY;
    }

    private static String[] phenotypePropIds(Metadata metadata) {
        HashSet<String> inPropIds = new HashSet<String>();
        for (PropositionDefinition phenotypeDef : metadata.getPhenotypeDefinitions()) {
            inPropIds.add(phenotypeDef.getId());
        }
        return inPropIds.toArray(new String[inPropIds.size()]);
    }
}

