/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.ksb;

import edu.emory.cci.aiw.i2b2etl.ksb.ValueSetSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.protempa.proposition.value.NominalValue;
import org.protempa.proposition.value.Value;
import org.protempa.proposition.value.ValueType;
import org.protempa.valueset.ValueSet;
import org.protempa.valueset.ValueSetElement;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class CMetadataXmlParser
extends DefaultHandler {
    private static final Logger LOGGER = Logger.getLogger(CMetadataXmlParser.class.getName());
    private String conceptBaseCode;
    private String tag;
    private final StringBuilder charBuffer;
    private ValueType valueType;
    private ValueSet valueSet;
    private final List<ValueSetElement> valueSetElements = new ArrayList<ValueSetElement>();
    private String valueSetElementDescription;
    private String unitsOfMeasure;
    private SAXParseException exception;
    private String declaringPropId;

    CMetadataXmlParser() {
        this.charBuffer = new StringBuilder();
    }

    String getDeclaringPropId() {
        return this.declaringPropId;
    }

    void setDeclaringPropId(String declaringPropId) {
        this.declaringPropId = declaringPropId;
    }

    void setConceptBaseCode(String conceptBaseCode) {
        this.conceptBaseCode = conceptBaseCode;
    }

    String getConceptBaseCode() {
        return this.conceptBaseCode;
    }

    ValueType getValueType() {
        return this.valueType;
    }

    ValueSet getValueSet() {
        return this.valueSet;
    }

    String getUnitsOfMeasure() {
        return this.unitsOfMeasure;
    }

    SAXParseException getException() {
        return this.exception;
    }

    @Override
    public void startDocument() throws SAXException {
        this.valueType = ValueType.VALUE;
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        switch (qName) {
            case "DataType": 
            case "Val": {
                this.tag = qName;
            }
        }
        switch (qName) {
            case "Val": {
                if (this.conceptBaseCode == null) break;
                this.valueSetElementDescription = atts.getValue("description");
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.tag != null) {
            this.charBuffer.append(String.valueOf(ch, start, length));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            switch (qName) {
                case "DataType": {
                    switch (String.valueOf(this.charBuffer)) {
                        case "PosInteger": 
                        case "Integer": 
                        case "Float": 
                        case "PosFloat": {
                            this.valueType = ValueType.NUMERICALVALUE;
                            return;
                        }
                        case "Enum": 
                        case "String": {
                            this.valueType = ValueType.NOMINALVALUE;
                            return;
                        }
                    }
                    this.valueType = ValueType.VALUE;
                    return;
                }
                case "Val": {
                    if (this.conceptBaseCode == null) return;
                    this.valueSetElements.add(new ValueSetElement((Value)NominalValue.getInstance((String)this.charBuffer.toString()), this.valueSetElementDescription));
                    this.valueSetElementDescription = null;
                    return;
                }
            }
            return;
        }
        finally {
            this.charBuffer.setLength(0);
            this.tag = null;
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (!this.valueSetElements.isEmpty()) {
            ValueSetSupport vsSupport = new ValueSetSupport();
            vsSupport.setDeclaringPropId(this.declaringPropId);
            vsSupport.setPropertyName(this.conceptBaseCode);
            this.valueSet = new ValueSet(vsSupport.getId(), null, this.valueSetElements.toArray(new ValueSetElement[this.valueSetElements.size()]), null);
            this.valueSetElements.clear();
        }
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.exception = e;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        LOGGER.log(Level.SEVERE, "Recoverable error while parsing c_metadataxml", e);
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        LOGGER.log(Level.WARNING, "Warning while parsing c_metadataxml", e);
    }
}

