/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid;

import edu.emory.cci.aiw.i2b2etl.dest.metadata.Metadata;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.ConceptId;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.InvalidConceptCodeException;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.PropDefConceptCodeBuilder;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.PropertyConceptId;
import java.util.ArrayList;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.proposition.value.Value;

public final class PropDefConceptId
implements PropertyConceptId {
    private final String propId;
    private final String propertyName;
    private final Value value;
    private String conceptCode;
    private final Metadata metadata;

    public static ConceptId getInstance(String propId, String propertyName, Metadata metadata) {
        return PropDefConceptId.getInstance(propId, propertyName, null, metadata);
    }

    public static PropDefConceptId getInstance(String propId, String propertyName, Value value, Metadata metadata) {
        ArrayList<Object> key = new ArrayList<Object>(4);
        key.add(propId);
        key.add(propertyName);
        key.add(value);
        key.add(Boolean.TRUE);
        PropDefConceptId conceptId = (PropDefConceptId)metadata.getFromConceptIdCache(key);
        if (conceptId == null) {
            conceptId = new PropDefConceptId(propId, propertyName, value, metadata);
            metadata.putInConceptIdCache(key, conceptId);
        }
        return conceptId;
    }

    private PropDefConceptId(String propId, String propertyName, Value value, Metadata metadata) {
        if (metadata == null) {
            throw new IllegalArgumentException("metadata cannot be null");
        }
        this.propId = propId;
        this.propertyName = propertyName;
        this.value = value;
        this.metadata = metadata;
    }

    @Override
    public String getId() {
        return this.propId;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    public Value getValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropDefConceptId other = (PropDefConceptId)obj;
        if (this.propId == null ? other.propId != null : !this.propId.equals(other.propId)) {
            return false;
        }
        if (this.propertyName == null ? other.propertyName != null : !this.propertyName.equals(other.propertyName)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int hash = 7;
        hash = 11 * hash + (this.propId != null ? this.propId.hashCode() : 0);
        hash = 11 * hash + (this.propertyName != null ? this.propertyName.hashCode() : 0);
        hash = 11 * hash + (this.value != null ? this.value.hashCode() : 0);
        return hash;
    }

    @Override
    public String toConceptCode() throws InvalidConceptCodeException {
        return this.toConceptCode(null);
    }

    @Override
    public String toConceptCode(String prefix) throws InvalidConceptCodeException {
        if (this.conceptCode == null) {
            PropDefConceptCodeBuilder ccBuilder = new PropDefConceptCodeBuilder(this.metadata);
            ccBuilder.setPropositionId(prefix != null ? prefix : this.propId);
            ccBuilder.setPropertyName(prefix != null ? null : this.propertyName);
            ccBuilder.setValue(this.value);
            this.conceptCode = ccBuilder.build();
        }
        return this.conceptCode;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

