/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid;

import edu.emory.cci.aiw.i2b2etl.dest.metadata.Metadata;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.InvalidConceptCodeException;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.PropertyConceptId;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.SimpleConceptCodeBuilder;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.proposition.value.Value;

public final class ModifierConceptId
implements PropertyConceptId {
    private final String propId;
    private final String propertyName;
    private final Value value;
    private String conceptCode;
    private final Metadata metadata;

    public static ModifierConceptId getInstance(String propId, String propertyName, Value value, Metadata metadata) {
        ArrayList<Object> key = new ArrayList<Object>(4);
        key.add(propId);
        key.add(propertyName);
        key.add(value);
        key.add(Boolean.FALSE);
        ModifierConceptId conceptId = (ModifierConceptId)metadata.getFromConceptIdCache(key);
        if (conceptId == null) {
            conceptId = new ModifierConceptId(propId, propertyName, value, metadata);
            metadata.putInConceptIdCache(key, conceptId);
        }
        return conceptId;
    }

    private ModifierConceptId(String propId, String propertyName, Value value, Metadata metadata) {
        if (metadata == null) {
            throw new IllegalArgumentException("metadata cannot be null");
        }
        this.propId = propId;
        this.propertyName = propertyName;
        this.metadata = metadata;
        this.value = value;
    }

    @Override
    public String getId() {
        return this.propId;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    public Value getValue() {
        return this.value;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this.propId);
        hash = 79 * hash + Objects.hashCode(this.propertyName);
        hash = 79 * hash + Objects.hashCode(this.conceptCode);
        hash = 79 * hash + Objects.hashCode(this.value);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModifierConceptId other = (ModifierConceptId)obj;
        if (!Objects.equals(this.propId, other.propId)) {
            return false;
        }
        if (!Objects.equals(this.propertyName, other.propertyName)) {
            return false;
        }
        if (!Objects.equals(this.conceptCode, other.conceptCode)) {
            return false;
        }
        return Objects.equals(this.value, other.value);
    }

    @Override
    public String toConceptCode() throws InvalidConceptCodeException {
        return this.toConceptCode(null);
    }

    @Override
    public String toConceptCode(String prefix) throws InvalidConceptCodeException {
        if (this.conceptCode == null) {
            SimpleConceptCodeBuilder ccBuilder = new SimpleConceptCodeBuilder(this.metadata);
            ccBuilder.setId((prefix != null ? prefix : "") + (this.value != null ? this.value.getFormatted() : ""));
            this.conceptCode = ccBuilder.build();
        }
        return this.conceptCode;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

