/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.dest.metadata;

import edu.emory.cci.aiw.i2b2etl.dest.metadata.Concept;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.Metadata;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.OntologyBuildException;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.OntologyBuilder;
import org.protempa.ProtempaUtil;

abstract class ParentBuilder
implements OntologyBuilder {
    private final String conceptCode;
    private final String displayName;
    private final OntologyBuilder[] children;
    private final Metadata metadata;
    private final boolean alreadyLoaded;

    ParentBuilder(Metadata metadata, String displayName, String conceptCode, boolean alreadyLoaded, OntologyBuilder ... children) {
        assert (metadata != null) : "metadata cannot be null";
        assert (displayName != null) : "displayName cannot be null";
        assert (conceptCode != null) : "conceptCode cannot be null";
        ProtempaUtil.checkArrayForNullElement((Object[])children, (String)"children");
        this.displayName = displayName;
        this.conceptCode = conceptCode;
        this.children = children;
        this.metadata = metadata;
        this.alreadyLoaded = alreadyLoaded;
    }

    @Override
    public void build(Concept parent) throws OntologyBuildException {
        Concept root = this.metadata.newContainerConcept(this.displayName, this.conceptCode);
        root.setAlreadyLoaded(this.alreadyLoaded);
        if (parent != null) {
            parent.add(root);
        }
        for (OntologyBuilder child : this.children) {
            child.build(root);
        }
    }
}

