/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.dest.metadata;

import edu.emory.cci.aiw.i2b2etl.dest.config.Data;
import edu.emory.cci.aiw.i2b2etl.dest.config.DataSpec;
import edu.emory.cci.aiw.i2b2etl.dest.config.Settings;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.Concept;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.ConceptOperator;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.Metadata;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.OntologyBuildException;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.OntologyBuilder;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.UnknownPropositionDefinitionException;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.ConceptId;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.InvalidConceptCodeException;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.PropDefConceptId;
import edu.emory.cci.aiw.i2b2etl.dest.metadata.conceptid.SimpleConceptId;
import org.protempa.KnowledgeSourceCache;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.PropertyDefinition;
import org.protempa.PropositionDefinition;
import org.protempa.ReferenceDefinition;
import org.protempa.proposition.value.Value;
import org.protempa.valueset.ValueSet;
import org.protempa.valueset.ValueSetElement;

abstract class DimensionValueSetFolderBuilder
implements OntologyBuilder {
    private final PropositionDefinition propDef;
    private final Data dataSection;
    private final Metadata metadata;
    private final String sourceSystemCode;
    private final String tableName;
    private final String factTableColumn;
    private final KnowledgeSourceCache cache;
    private final String childName;
    private final String dictVal;
    private final String columnName;
    private final Settings settings;

    DimensionValueSetFolderBuilder(KnowledgeSourceCache cache, Metadata metadata, String childName, String dictVal, String columnName) throws OntologyBuildException {
        block8: {
            assert (cache != null) : "cache cannot be null";
            assert (metadata != null) : "metadata cannot be null";
            assert (childName != null) : "childName cannot be null";
            assert (columnName != null) : "columnName cannot be null";
            this.cache = cache;
            this.dataSection = metadata.getDataSection();
            this.metadata = metadata;
            this.sourceSystemCode = metadata.getSourceSystemCode();
            this.factTableColumn = "patient_num";
            this.tableName = "patient_dimension";
            this.settings = metadata.getSettings();
            String propId = this.settings.getVisitDimension();
            if (propId != null) {
                try {
                    this.propDef = cache.get(propId);
                    if (this.propDef == null) {
                        throw new UnknownPropositionDefinitionException(propId);
                    }
                    break block8;
                }
                catch (UnknownPropositionDefinitionException ex) {
                    throw new OntologyBuildException("Could not build descendants", ex);
                }
            }
            this.propDef = null;
        }
        this.childName = childName;
        this.dictVal = dictVal;
        this.columnName = columnName;
    }

    Settings getSettings() {
        return this.settings;
    }

    @Override
    public void build(Concept parent) throws OntologyBuildException {
        DataSpec dataSpec = this.getDataSection(this.dictVal);
        if (dataSpec != null && this.propDef != null) {
            ConceptId conceptId = SimpleConceptId.getInstance(this.childName, this.metadata);
            Concept concept = this.newQueryableConcept(conceptId, dataSpec.getConceptCodePrefix());
            concept.setColumnName(this.columnName);
            concept.setOperator(ConceptOperator.NOT_EQUAL);
            concept.setDisplayName(this.childName);
            concept.setAlreadyLoaded(parent.isAlreadyLoaded());
            if (dataSpec.getReferenceName() != null) {
                try {
                    this.addChildrenFromValueSets(this.propDef, dataSpec, concept, this.columnName);
                }
                catch (InvalidConceptCodeException | KnowledgeSourceReadException ex) {
                    throw new OntologyBuildException("Could not build descendants", ex);
                }
            }
            concept.setDimCode("''");
            parent.add(concept);
        }
    }

    private DataSpec getDataSection(String dictVal) {
        if (dictVal != null) {
            return this.dataSection.get(dictVal);
        }
        return null;
    }

    private void addChildrenFromValueSets(PropositionDefinition propDef, DataSpec dataSpec, Concept concept, String columnName) throws OntologyBuildException, UnsupportedOperationException, KnowledgeSourceReadException, InvalidConceptCodeException {
        String[] propIds;
        ReferenceDefinition refDef = propDef.referenceDefinition(dataSpec.getReferenceName());
        for (String propId : propIds = refDef.getPropositionIds()) {
            ValueSetElement[] valueSetElements;
            String valueSetId;
            PropertyDefinition propertyDef;
            PropositionDefinition propositionDef = this.cache.get(propId);
            if (propositionDef == null || (propertyDef = propositionDef.propertyDefinition(dataSpec.getPropertyName())) == null || (valueSetId = propertyDef.getValueSetId()) == null) continue;
            ValueSet valueSet = this.cache.getValueSet(valueSetId);
            for (ValueSetElement valueSetElement : valueSetElements = valueSet.getValueSetElements()) {
                Value valueSetElementVal = valueSetElement.getValue();
                PropDefConceptId conceptId = PropDefConceptId.getInstance(propId, dataSpec.getPropertyName(), valueSetElementVal, this.metadata);
                Concept childConcept = this.newQueryableConcept(conceptId, dataSpec.getConceptCodePrefix());
                childConcept.setDisplayName(valueSetElement.getDisplayName());
                childConcept.setColumnName(columnName);
                childConcept.setDimCode(valueSetElementVal != null ? valueSetElementVal.getFormatted() : "");
                childConcept.setOperator(ConceptOperator.EQUAL);
                childConcept.setAlreadyLoaded(concept.isAlreadyLoaded());
                concept.add(childConcept);
            }
        }
    }

    private Concept newQueryableConcept(ConceptId conceptId, String conceptCodePrefix) throws OntologyBuildException {
        Concept concept = this.metadata.newConcept(conceptId, conceptCodePrefix, this.sourceSystemCode);
        concept.setFactTableColumn(this.factTableColumn);
        concept.setTableName(this.tableName);
        return concept;
    }
}

