/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.dest.config.xml;

import edu.emory.cci.aiw.i2b2etl.dest.config.ConfigurationInitException;
import edu.emory.cci.aiw.i2b2etl.dest.config.DataSourceDatabaseSpec;
import edu.emory.cci.aiw.i2b2etl.dest.config.Database;
import edu.emory.cci.aiw.i2b2etl.dest.config.DatabaseSpec;
import edu.emory.cci.aiw.i2b2etl.dest.config.DriverManagerDatabaseSpec;
import edu.emory.cci.aiw.i2b2etl.dest.config.xml.ConfigurationSection;
import java.util.TreeMap;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

final class DatabaseSection
extends ConfigurationSection
implements Database {
    private static final String META_SCHEMA_DRIVER_MANAGER = "metaschema";
    private static final String DATA_SCHEMA_DRIVER_MANAGER = "dataschema";
    private static final String META_SCHEMA_DATA_SOURCE = "metaschemaDataSource";
    private static final String DATA_SCHEMA_DATA_SOURCE = "dataschemaDataSource";
    private TreeMap<String, DatabaseSpec> dbs = new TreeMap();

    DatabaseSection() {
    }

    DatabaseSpec get(String schema) {
        return this.dbs.get(schema);
    }

    @Override
    protected void put(Node node) throws ConfigurationInitException {
        DatabaseSpec databaseSpec;
        NamedNodeMap nnm = node.getAttributes();
        String keyAttribute = DatabaseSection.readAttribute(nnm, "key", true);
        if (keyAttribute.equals(META_SCHEMA_DRIVER_MANAGER) || keyAttribute.equals(DATA_SCHEMA_DRIVER_MANAGER)) {
            databaseSpec = new DriverManagerDatabaseSpec(DatabaseSection.readAttribute(nnm, "connect", true), DatabaseSection.readAttribute(nnm, "user", true), DatabaseSection.readAttribute(nnm, "passwd", true));
        } else if (keyAttribute.equals(META_SCHEMA_DATA_SOURCE) || keyAttribute.equals(DATA_SCHEMA_DATA_SOURCE)) {
            databaseSpec = new DataSourceDatabaseSpec(DatabaseSection.readAttribute(nnm, "connect", true), DatabaseSection.readAttribute(nnm, "user", false), DatabaseSection.readAttribute(nnm, "passwd", false));
        } else {
            throw new ConfigurationInitException("Invalid dbschema key: " + keyAttribute);
        }
        this.dbs.put(keyAttribute, databaseSpec);
    }

    @Override
    protected String getNodeName() {
        return "dbschema";
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public DatabaseSpec getMetadataSpec() {
        DatabaseSpec databaseSpec = this.dbs.get(META_SCHEMA_DRIVER_MANAGER);
        if (databaseSpec != null) {
            return databaseSpec;
        }
        return this.dbs.get(META_SCHEMA_DATA_SOURCE);
    }

    @Override
    public DatabaseSpec getDataSpec() {
        DatabaseSpec databaseSpec = this.dbs.get(DATA_SCHEMA_DRIVER_MANAGER);
        if (databaseSpec != null) {
            return databaseSpec;
        }
        return this.dbs.get(DATA_SCHEMA_DATA_SOURCE);
    }
}

