/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.dest.config.xml;

import edu.emory.cci.aiw.i2b2etl.dest.config.ConfigurationInitException;
import edu.emory.cci.aiw.i2b2etl.dest.config.Data;
import edu.emory.cci.aiw.i2b2etl.dest.config.DataSpec;
import edu.emory.cci.aiw.i2b2etl.dest.config.xml.ConfigurationSection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

final class DataSection
extends ConfigurationSection
implements Data {
    private final Map<String, DataSpec> obxSpecs = new HashMap<String, DataSpec>();

    DataSection() {
    }

    @Override
    public DataSpec get(String key) {
        return this.obxSpecs.get(key);
    }

    @Override
    public Collection<DataSpec> getAll() {
        return this.obxSpecs.values();
    }

    @Override
    protected void put(Node node) throws ConfigurationInitException {
        NamedNodeMap nnm = node.getAttributes();
        DataSpec dataSpec = new DataSpec(DataSection.readAttribute(nnm, "key", true), DataSection.readAttribute(nnm, "reference", false), DataSection.readAttribute(nnm, "property", false), DataSection.readAttribute(nnm, "conceptCodePrefix", false), DataSection.readAttribute(nnm, "start", false), DataSection.readAttribute(nnm, "finish", false), DataSection.readAttribute(nnm, "units", false));
        if (dataSpec.getStart() != null && !dataSpec.getStart().equals("start") && !dataSpec.getStart().equals("finish")) {
            throw new ConfigurationInitException("The start attribute must have a value of 'start' or 'finish'");
        }
        if (dataSpec.getFinish() != null && !dataSpec.getFinish().equals("start") && !dataSpec.getFinish().equals("finish")) {
            throw new ConfigurationInitException("The finish attribute must have a value of 'start' or 'finish'");
        }
        if (dataSpec.getReferenceName() == null && dataSpec.getPropertyName() == null) {
            throw new ConfigurationInitException("Either referenceName or propertyName must be defined in dataType");
        }
        this.obxSpecs.put(dataSpec.getKey(), dataSpec);
    }

    @Override
    protected String getNodeName() {
        return "dataType";
    }

    String getString() {
        StringBuilder sb = new StringBuilder();
        for (DataSpec obx : this.obxSpecs.values()) {
            sb.append(obx.getReferenceName());
            sb.append(" : ");
            sb.append(obx.getPropertyName()).append("\n");
        }
        return sb.toString();
    }
}

