/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.dest.config.xml;

import edu.emory.cci.aiw.i2b2etl.dest.config.ConfigurationInitException;
import edu.emory.cci.aiw.i2b2etl.dest.config.xml.ConceptsSection;
import edu.emory.cci.aiw.i2b2etl.dest.config.xml.DataSection;
import edu.emory.cci.aiw.i2b2etl.dest.config.xml.DatabaseSection;
import edu.emory.cci.aiw.i2b2etl.dest.config.xml.DictionarySection;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

final class ConfigurationReader {
    private final DictionarySection dictionary;
    private final DatabaseSection database;
    private final ConceptsSection concepts;
    private final DataSection data;
    private final File conf;

    ConfigurationReader(File confFile) {
        this.conf = confFile;
        this.dictionary = new DictionarySection();
        this.database = new DatabaseSection();
        this.concepts = new ConceptsSection();
        this.data = new DataSection();
    }

    void read() throws ConfigurationInitException {
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = db.parse(this.conf);
            Element eRoot = doc.getDocumentElement();
            NodeList nL = eRoot.getChildNodes();
            for (int i = 0; i < nL.getLength(); ++i) {
                Node node = nL.item(i);
                if (node.getNodeType() != 1) continue;
                if (node.getNodeName().equals("dictionary")) {
                    this.dictionary.load((Element)node);
                    continue;
                }
                if (node.getNodeName().equals("database")) {
                    this.database.load((Element)node);
                    continue;
                }
                if (node.getNodeName().equals("concepts")) {
                    this.concepts.load((Element)node);
                    continue;
                }
                if (!node.getNodeName().equals("data")) continue;
                this.data.load((Element)node);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            throw new ConfigurationInitException("Could not read configuration file " + this.conf.getAbsolutePath(), ex);
        }
    }

    DictionarySection getDictionarySection() {
        return this.dictionary;
    }

    DatabaseSection getDatabaseSection() {
        return this.database;
    }

    ConceptsSection getConceptsSection() {
        return this.concepts;
    }

    DataSection getDataSection() {
        return this.data;
    }
}

