/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.i2b2etl.dest.config;

import edu.emory.cci.aiw.i2b2etl.dest.config.DatabaseSpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arp.javautil.sql.DatabaseAPI;

public class DriverManagerDatabaseSpec
extends DatabaseSpec {
    private static final Logger LOGGER = Logger.getLogger(DriverManagerDatabaseSpec.class.getName());
    private static final String[] jdbcDriverClassNames = new String[]{"oracle.jdbc.OracleDriver", "org.postgresql.Driver", "org.h2.Driver"};

    public DriverManagerDatabaseSpec(String connect, String user, String passwd) {
        super(connect, user, passwd);
        DriverManagerDatabaseSpec.loadDrivers();
    }

    @Override
    public DatabaseAPI getDatabaseAPI() {
        return DatabaseAPI.DRIVERMANAGER;
    }

    private static void loadDrivers() {
        for (String driverClassName : jdbcDriverClassNames) {
            try {
                Class.forName(driverClassName);
                LOGGER.log(Level.FINE, "JDBC driver {0} found", driverClassName);
            }
            catch (ClassNotFoundException ex) {
                LOGGER.log(Level.FINE, "No JDBC driver {0} found", driverClassName);
            }
        }
    }
}

