/*
 * Decompiled with CFR 0.152.
 */
package org.eu.sbin.commons.opc.ua.client.cmd;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.stack.client.security.ClientCertificateValidator;
import org.eclipse.milo.opcua.stack.client.security.DefaultClientCertificateValidator;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.security.DefaultTrustListManager;
import org.eclipse.milo.opcua.stack.core.security.TrustListManager;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eu.sbin.commons.opc.ua.client.IOpcUaClient;
import org.eu.sbin.commons.opc.ua.client.KeyStoreLoader;
import org.eu.sbin.commons.opc.ua.client.cmd.CmdOpcUaCollectorBuilder;
import org.eu.vooo.commons.iot.cmd.AbstractCmdCollector;
import org.eu.vooo.commons.iot.device.IDevice;
import org.eu.vooo.commons.iot.device.IIpParameter;
import org.eu.vooo.commons.iot.exception.XCollectDeviceException;
import org.eu.vooo.commons.iot.exception.XCollectSensorException;
import org.eu.vooo.commons.iot.exception.XCollectorInitException;
import org.eu.vooo.commons.iot.exception.XNetworkException;
import org.eu.vooo.commons.iot.sensor.ISensor;
import org.eu.vooo.commons.iot.sensor.IUASensor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmdOpcUaCollector<D extends IDevice>
extends AbstractCmdCollector
implements IOpcUaClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(CmdOpcUaCollector.class);
    private OpcUaClient opcUaClient;
    private UShort namespaceSpaceIndex;
    private final CompletableFuture<OpcUaClient> opcUaClientCompletableFuture = new CompletableFuture();

    public CmdOpcUaCollector(Builder<D> builder) {
        this.deviceHolder = builder.deviceHolder;
    }

    protected void init() {
        try {
            this.run();
        }
        catch (Exception e) {
            LOGGER.warn("\u521b\u5efaOPC UA CLIENT \u5931\u8d25");
            throw new XCollectorInitException("\u521d\u59cb\u5316 OPC UA CLIENT \u5931\u8d25");
        }
    }

    public synchronized void tryConnect(IDevice device) {
        if (Objects.isNull(device.getIpParameter())) {
            throw new XNetworkException("\u8fde\u63a5\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            if (Objects.nonNull(this.opcUaClient) && !"on".equals(this.deviceHolder.getRunStatus())) {
                this.opcUaClient.connect().get(15L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new XNetworkException("\u8fde\u63a5\u5931\u8d25");
        }
    }

    public void read(ISensor sensor) {
        try {
            StringBuilder nodeIdPrepare = new StringBuilder();
            nodeIdPrepare.append("ns=");
            nodeIdPrepare.append(this.namespaceSpaceIndex.intValue());
            nodeIdPrepare.append(";");
            nodeIdPrepare.append("s=");
            nodeIdPrepare.append(((IUASensor)sensor).getUaChannel());
            nodeIdPrepare.append(".");
            nodeIdPrepare.append(((IUASensor)sensor).getUaDevice());
            nodeIdPrepare.append(".");
            nodeIdPrepare.append(((IUASensor)sensor).getUaTag());
            NodeId nodeId = NodeId.parse((String)nodeIdPrepare.toString());
            DataValue dataValue = (DataValue)this.opcUaClient.readValue(0.0, TimestampsToReturn.Neither, nodeId).get();
            Variant variant = dataValue.getValue();
            Object value = variant.getValue();
            sensor.setValue(value.toString());
        }
        catch (InterruptedException | ExecutionException e) {
            if (e.getCause() instanceof UaException) {
                throw new XCollectDeviceException("\u8bbe\u5907\u5f02\u5e38");
            }
            throw new XCollectSensorException("\u83b7\u53d6\u4f20\u611f\u5668\u5f02\u5e38");
        }
    }

    public <T extends ISensor> void read(List<T> sensorList) throws Exception {
    }

    public synchronized void tryDisconnect(IDevice device) {
        this.opcUaClient.disconnect();
    }

    private OpcUaClient createClient() throws Exception {
        Path securityTempDir = Paths.get(System.getProperty("java.io.tmpdir"), "client", "security");
        Files.createDirectories(securityTempDir, new FileAttribute[0]);
        if (!Files.exists(securityTempDir, new LinkOption[0])) {
            throw new Exception("\u65e0\u6cd5\u521b\u5efa\u5b89\u5168\u914d\u7f6e\u76ee\u5f55: " + securityTempDir);
        }
        File pkiDir = securityTempDir.resolve("pki").toFile();
        KeyStoreLoader loader = new KeyStoreLoader().load(securityTempDir);
        DefaultTrustListManager trustListManager = new DefaultTrustListManager(pkiDir);
        DefaultClientCertificateValidator certificateValidator = new DefaultClientCertificateValidator((TrustListManager)trustListManager);
        StringBuilder endpointUrl = new StringBuilder();
        IIpParameter ipParameter = this.deviceHolder.getIpParameter();
        if (Objects.isNull(ipParameter)) {
            throw new XCollectorInitException("\u7f51\u7edc\u914d\u7f6e\u5f02\u5e38");
        }
        endpointUrl.append("opc.tcp://").append(ipParameter.getHost()).append(":").append(ipParameter.getPort());
        return OpcUaClient.create((String)endpointUrl.toString(), endpoints -> endpoints.stream().filter(this.getEndpointFilter()).findFirst(), configBuilder -> configBuilder.setApplicationName(LocalizedText.english((String)"collector opc-ua client")).setApplicationUri("urn:org:eu:sbin:collector:client").setKeyPair(loader.getClientKeyPair()).setCertificate(loader.getClientCertificate()).setCertificateChain(loader.getClientCertificateChain()).setCertificateValidator((ClientCertificateValidator)certificateValidator).setIdentityProvider(this.getIdentityProvider()).setRequestTimeout(Unsigned.uint((int)5000)).build());
    }

    @Override
    public void run() throws Exception {
        this.opcUaClient = this.createClient();
        this.run(this.opcUaClient, this.opcUaClientCompletableFuture);
        this.opcUaClientCompletableFuture.get(15L, TimeUnit.SECONDS);
        this.opcUaClientCompletableFuture.whenCompleteAsync((c, ex) -> {
            if (Objects.nonNull(ex)) {
                this.deviceHolder.setRunStatus("ex");
                this.deviceHolder.setRunStatusMsg(ex.getMessage());
            } else {
                this.deviceHolder.setRunStatus("on");
                this.deviceHolder.setRunStatusMsg("\u5728\u7ebf");
            }
        });
    }

    @Override
    public void run(OpcUaClient client, CompletableFuture<OpcUaClient> future) throws Exception {
        client.connect().get();
        String namespace = this.deviceHolder.getIpParameter().getNameSpace();
        this.namespaceSpaceIndex = client.readNamespaceTable().getIndex(namespace);
        future.complete(client);
    }

    public static class Builder<D extends IDevice>
    extends CmdOpcUaCollectorBuilder<D> {
        public CmdOpcUaCollector<D> build() {
            return new CmdOpcUaCollector(this);
        }
    }
}

