/*
 * Decompiled with CFR 0.152.
 */
package org.eu.sbin.commons.opc.ua.client;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.eclipse.milo.opcua.stack.core.util.SelfSignedCertificateBuilder;
import org.eclipse.milo.opcua.stack.core.util.SelfSignedCertificateGenerator;
import org.eu.sbin.commons.opc.ua.util.HostnameUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreLoader {
    private static final Pattern IP_ADDR_PATTERN = Pattern.compile("^(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");
    private static final String CLIENT_ALIAS = "client-ai";
    private static final char[] PASSWORD = "password".toCharArray();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private X509Certificate[] clientCertificateChain;
    private X509Certificate clientCertificate;
    private KeyPair clientKeyPair;

    public KeyStoreLoader load(Path baseDir) throws Exception {
        Throwable builder;
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        Path serverKeyStore = baseDir.resolve("example-client.pfx");
        this.logger.info("Loading KeyStore at {}", (Object)serverKeyStore);
        if (!Files.exists(serverKeyStore, new LinkOption[0])) {
            keyStore.load(null, PASSWORD);
            KeyPair keyPair = SelfSignedCertificateGenerator.generateRsaKeyPair((int)2048);
            builder = new SelfSignedCertificateBuilder(keyPair).setCommonName("Collector Client").setOrganization("ngyj").setOrganizationalUnit("dev").setLocalityName("NJ").setStateName("JS").setCountryCode("CN").setApplicationUri("urn:org:eu:vooo:collector:client").addDnsName("localhost").addIpAddress("127.0.0.1");
            for (String hostname : HostnameUtil.getHostnames("0.0.0.0")) {
                if (IP_ADDR_PATTERN.matcher(hostname).matches()) {
                    builder.addIpAddress(hostname);
                    continue;
                }
                builder.addDnsName(hostname);
            }
            X509Certificate certificate = builder.build();
            keyStore.setKeyEntry(CLIENT_ALIAS, keyPair.getPrivate(), PASSWORD, new X509Certificate[]{certificate});
            try (OutputStream out = Files.newOutputStream(serverKeyStore, new OpenOption[0]);){
                keyStore.store(out, PASSWORD);
            }
        }
        builder = null;
        try (InputStream in = Files.newInputStream(serverKeyStore, new OpenOption[0]);){
            keyStore.load(in, PASSWORD);
        }
        catch (Throwable throwable) {
            builder = throwable;
            throw throwable;
        }
        Key clientPrivateKey = keyStore.getKey(CLIENT_ALIAS, PASSWORD);
        if (clientPrivateKey instanceof PrivateKey) {
            this.clientCertificate = (X509Certificate)keyStore.getCertificate(CLIENT_ALIAS);
            this.clientCertificateChain = (X509Certificate[])Arrays.stream(keyStore.getCertificateChain(CLIENT_ALIAS)).map(X509Certificate.class::cast).toArray(X509Certificate[]::new);
            PublicKey serverPublicKey = this.clientCertificate.getPublicKey();
            this.clientKeyPair = new KeyPair(serverPublicKey, (PrivateKey)clientPrivateKey);
        }
        return this;
    }

    public X509Certificate getClientCertificate() {
        return this.clientCertificate;
    }

    public X509Certificate[] getClientCertificateChain() {
        return this.clientCertificateChain;
    }

    public KeyPair getClientKeyPair() {
        return this.clientKeyPair;
    }
}

