package org.eu.sbin.commons.opc.ua.client;

import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.identity.AnonymousProvider;
import org.eclipse.milo.opcua.sdk.client.api.identity.IdentityProvider;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;

import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;

/**
 * @author lxj990@gmail.com
 */
public interface IOpcUaClient {

    default String getEndpointUrl() {
        return "opc.tcp://127.0.0.1:49320";
    }

    default Predicate<EndpointDescription> getEndpointFilter() {
        return e -> getSecurityPolicy().getUri().equals(e.getSecurityPolicyUri());
    }

    default SecurityPolicy getSecurityPolicy() {
        return SecurityPolicy.None;
    }

    default IdentityProvider getIdentityProvider() {
        return new AnonymousProvider();
    }

    void run() throws Exception;

    void run(OpcUaClient client, CompletableFuture<OpcUaClient> future) throws Exception;

}
