/*
 * Decompiled with CFR 0.152.
 */
package org.esbtools.eventhandler.lightblue.locking;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.esbtools.eventhandler.lightblue.locking.LockedResource;
import org.esbtools.eventhandler.lightblue.locking.LockedResources;
import org.esbtools.eventhandler.lightblue.locking.MultipleIOExceptions;

class WrappedLockedResources<T>
implements LockedResources<T> {
    private final Collection<LockedResource<T>> locks;

    public WrappedLockedResources(Collection<LockedResource<T>> locks) {
        this.locks = locks;
    }

    @Override
    public Collection<LockedResource<T>> getLocks() {
        return Collections.unmodifiableCollection(this.locks);
    }

    @Override
    public void close() throws IOException {
        if (this.locks.isEmpty()) {
            return;
        }
        ArrayList<IOException> exceptions = new ArrayList<IOException>(0);
        for (LockedResource<T> lock : this.locks) {
            try {
                lock.close();
            }
            catch (IOException e) {
                exceptions.add(e);
            }
        }
        if (!exceptions.isEmpty()) {
            if (exceptions.size() == 1) {
                throw (IOException)exceptions.get(0);
            }
            throw new MultipleIOExceptions(exceptions);
        }
    }
}

