/*
 * Decompiled with CFR 0.152.
 */
package org.esbtools.eventhandler.lightblue.locking;

import com.redhat.lightblue.client.LightblueException;
import com.redhat.lightblue.client.Locking;
import com.redhat.lightblue.client.response.lock.InvalidLockException;
import java.io.IOException;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.esbtools.eventhandler.lightblue.locking.LockNotAvailableException;
import org.esbtools.eventhandler.lightblue.locking.LockStrategy;
import org.esbtools.eventhandler.lightblue.locking.LockedResource;
import org.esbtools.eventhandler.lightblue.locking.LostLockException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightblueAutoPingLockStrategy
implements LockStrategy {
    private final Locking locking;
    private final Duration autoPingInterval;
    private final Duration timeToLive;

    public LightblueAutoPingLockStrategy(Locking locking, Duration autoPingInterval) {
        this(locking, autoPingInterval, autoPingInterval.multipliedBy(5L));
    }

    public LightblueAutoPingLockStrategy(Locking locking, Duration autoPingInterval, Duration timeToLive) {
        this.locking = locking;
        this.autoPingInterval = autoPingInterval;
        this.timeToLive = timeToLive;
        if (timeToLive.compareTo(autoPingInterval) <= 0) {
            throw new IllegalArgumentException("Time to live should be greater than auto ping interval, otherwise the lock will likely be lost.");
        }
    }

    @Override
    public <T> LockedResource<T> tryAcquire(String resourceId, T resource) throws LockNotAvailableException {
        try {
            String callerId = UUID.randomUUID().toString();
            return new AutoPingingLock<T>(this.locking, callerId, resourceId, resource, this.autoPingInterval, this.timeToLive);
        }
        catch (LightblueException e) {
            throw new LockNotAvailableException(resourceId, resource, (Exception)((Object)e));
        }
    }

    static final class AutoPingingLock<T>
    implements LockedResource<T> {
        private final String callerId;
        private final T resource;
        private final String resourceId;
        private final Locking locking;
        private final ScheduledExecutorService autoPingScheduler = Executors.newSingleThreadScheduledExecutor();
        private final ScheduledFuture<?> autoPinger;
        private final AtomicBoolean isClosed = new AtomicBoolean(false);
        private static final Logger logger = LoggerFactory.getLogger(AutoPingingLock.class);

        AutoPingingLock(Locking locking, String callerId, String resourceId, T resource, Duration autoPingInterval, Duration ttl) throws LightblueException, LockNotAvailableException {
            this.callerId = callerId;
            this.resource = resource;
            this.locking = locking;
            this.resourceId = resourceId;
            if (!locking.acquire(callerId, resourceId, Long.valueOf(ttl.toMillis()))) {
                throw new LockNotAvailableException(resourceId, resource);
            }
            this.autoPinger = this.autoPingScheduler.scheduleWithFixedDelay(new PingTask(this), autoPingInterval.toMillis(), autoPingInterval.toMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public void ensureAcquiredOrThrow(String lostLockMessage) throws LostLockException {
            try {
                if (!this.locking.ping(this.callerId, this.resourceId)) {
                    this.stopPinging();
                    throw new LostLockException(this, lostLockMessage);
                }
            }
            catch (LightblueException e) {
                try {
                    this.close();
                }
                catch (IOException suppressed) {
                    logger.warn("Caught IOException trying to release lock after failed ping. Ignoring.", (Throwable)suppressed);
                }
                throw new LostLockException(this, "Failed to ping lock, assuming lost. This can happen if lock is already closed or failed to communicate with lightblue. " + lostLockMessage, (Exception)((Object)e));
            }
        }

        @Override
        public T getResource() {
            return this.resource;
        }

        @Override
        public void close() throws IOException {
            if (this.isClosed.get()) {
                return;
            }
            try {
                this.autoPinger.cancel(true);
                this.autoPingScheduler.shutdownNow();
                this.locking.release(this.callerId, this.resourceId);
                this.isClosed.set(true);
            }
            catch (LightblueException e) {
                throw new IOException("Unable to release lock. callerId: " + this.callerId + ", resourceId: " + this.resourceId, e);
            }
        }

        public String toString() {
            return "AutoPingingLock{resourceId='" + this.resourceId + '\'' + ", callerId='" + this.callerId + '\'' + ", lockingDomain='" + this.locking.getDomain() + '\'' + '}';
        }

        private void stopPinging() {
            this.autoPinger.cancel(true);
            this.autoPingScheduler.shutdownNow();
            this.isClosed.set(true);
        }

        static class PingTask
        implements Runnable {
            final AutoPingingLock lock;

            PingTask(AutoPingingLock lock) {
                this.lock = lock;
            }

            @Override
            public void run() {
                try {
                    if (!this.lock.locking.ping(this.lock.callerId, this.lock.resourceId)) {
                        this.lock.stopPinging();
                        throw new RuntimeException("Lost lock. Will stop pinging. Lock was: " + this.lock);
                    }
                    logger.debug("Periodic lock ping successful. callerId={} resourceId={}", (Object)this.lock.callerId, (Object)this.lock.resourceId);
                }
                catch (InvalidLockException e) {
                    logger.error("Tried to ping an invalid lock. Will stop pinging. Lock was: " + this.lock, (Throwable)e);
                    this.lock.stopPinging();
                    throw new RuntimeException(e);
                }
                catch (LightblueException e) {
                    logger.error("Periodic lock ping failed for callerId <{}> and resourceId <{}>. Will keep trying.", new Object[]{this.lock.callerId, this.lock.resourceId, e});
                }
            }
        }
    }
}

