/*
 * Decompiled with CFR 0.152.
 */
package org.esbtools.eventhandler.lightblue.config;

import com.redhat.lightblue.client.LightblueClient;
import com.redhat.lightblue.client.request.LightblueDataRequest;
import com.redhat.lightblue.client.request.data.DataFindRequest;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.builder.RouteBuilder;
import org.esbtools.eventhandler.lightblue.client.FindRequests;
import org.esbtools.eventhandler.lightblue.config.EventHandlerConfigEntity;
import org.esbtools.eventhandler.lightblue.config.MutableLightblueDocumentEventRepositoryConfig;
import org.esbtools.eventhandler.lightblue.config.MutableLightblueNotificationRepositoryConfig;

public class PollingLightblueConfigUpdateRoute
extends RouteBuilder {
    private final String configDomain;
    private final Duration pollingInterval;
    private final LightblueClient lightblue;
    private final MutableLightblueNotificationRepositoryConfig notificationRepositoryConfig;
    private final MutableLightblueDocumentEventRepositoryConfig documentEventRepositoryConfig;
    private final DataFindRequest findConfig;
    private static final AtomicInteger idCounter = new AtomicInteger(1);
    private final int id = idCounter.getAndIncrement();

    public PollingLightblueConfigUpdateRoute(String configDomain, Duration pollingInterval, LightblueClient lightblue, MutableLightblueNotificationRepositoryConfig notificationRepositoryConfig, MutableLightblueDocumentEventRepositoryConfig documentEventRepositoryConfig) {
        this.pollingInterval = Objects.requireNonNull(pollingInterval, "pollingInterval");
        this.lightblue = Objects.requireNonNull(lightblue, "lightblue");
        this.notificationRepositoryConfig = Objects.requireNonNull(notificationRepositoryConfig, "notificationRepositoryConfig");
        this.documentEventRepositoryConfig = Objects.requireNonNull(documentEventRepositoryConfig, "documentEventRepositoryConfig");
        this.configDomain = Objects.requireNonNull(configDomain, "configDomain");
        this.findConfig = FindRequests.eventHandlerConfigForDomain(configDomain);
    }

    public void configure() throws Exception {
        this.from("timer:pollForEventHandlerConfigUpdates" + this.id + "?period=" + this.pollingInterval.toMillis()).routeId("eventHandlerConfigUpdater-" + this.id).process(exchange -> {
            Duration documentEventExpireThreshold;
            Duration documentEventProcessingTimeout;
            Duration notificationExpireThreshold;
            Duration notificationProcessingTimeout;
            Integer documentEventBatchSize;
            Set<String> entityNames;
            EventHandlerConfigEntity storedConfig = (EventHandlerConfigEntity)this.lightblue.data((LightblueDataRequest)this.findConfig, EventHandlerConfigEntity.class);
            if (storedConfig == null) {
                this.log.info("No event handler config found for domain: {}", (Object)this.configDomain);
                return;
            }
            Set<String> canonicalTypes = storedConfig.getCanonicalTypesToProcess();
            if (canonicalTypes != null) {
                this.documentEventRepositoryConfig.setCanonicalTypesToProcess(canonicalTypes);
            }
            if ((entityNames = storedConfig.getEntityNamesToProcess()) != null) {
                this.notificationRepositoryConfig.setEntityNamesToProcess(entityNames);
            }
            if ((documentEventBatchSize = storedConfig.getDocumentEventsBatchSize()) != null) {
                this.documentEventRepositoryConfig.setDocumentEventsBatchSize(documentEventBatchSize);
            }
            if ((notificationProcessingTimeout = storedConfig.getNotificationProcessingTimeout()) != null) {
                this.notificationRepositoryConfig.setNotificationProcessingTimeout(notificationProcessingTimeout);
            }
            if ((notificationExpireThreshold = storedConfig.getNotificationExpireThreshold()) != null) {
                this.notificationRepositoryConfig.setNotificationExpireThreshold(notificationExpireThreshold);
            }
            if ((documentEventProcessingTimeout = storedConfig.getDocumentEventProcessingTimeout()) != null) {
                this.documentEventRepositoryConfig.setDocumentEventProcessingTimeout(documentEventProcessingTimeout);
            }
            if ((documentEventExpireThreshold = storedConfig.getDocumentEventExpireThreshold()) != null) {
                this.documentEventRepositoryConfig.setDocumentEventExpireThreshold(documentEventExpireThreshold);
            }
            Optional<Integer> maxDocumentEventsPerInsert = storedConfig.getOptionalMaxDocumentEventsPerInsert();
            this.documentEventRepositoryConfig.setMaxDocumentEventsPerInsert(maxDocumentEventsPerInsert);
        });
    }
}

