/*
 * Decompiled with CFR 0.152.
 */
package org.esbtools.eventhandler.lightblue.config;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.esbtools.eventhandler.lightblue.LightblueNotificationRepositoryConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class MutableLightblueNotificationRepositoryConfig
implements LightblueNotificationRepositoryConfig {
    private Set<String> entityNamesToProcess;
    private Duration processingTimeout;
    private Duration expireThreshold;
    private static final Logger log = LoggerFactory.getLogger(MutableLightblueNotificationRepositoryConfig.class);

    public MutableLightblueNotificationRepositoryConfig() {
        this.entityNamesToProcess = Collections.emptySet();
        this.processingTimeout = Duration.ofMinutes(10L);
        this.expireThreshold = Duration.ofMinutes(2L);
    }

    public MutableLightblueNotificationRepositoryConfig(Collection<String> initialEntityNamesToProcess, Duration processingTimeout, Duration expireThreshold) {
        this.processingTimeout = Objects.requireNonNull(processingTimeout, "processingTimeout");
        this.expireThreshold = Objects.requireNonNull(expireThreshold, "expireThreshold");
        this.entityNamesToProcess = Collections.unmodifiableSet(new HashSet<String>(Objects.requireNonNull(initialEntityNamesToProcess, "initialEntityNamesToProcess")));
    }

    @Override
    public Set<String> getEntityNamesToProcess() {
        return this.entityNamesToProcess;
    }

    public MutableLightblueNotificationRepositoryConfig setEntityNamesToProcess(Collection<String> entityNames) {
        Set<String> old = this.entityNamesToProcess;
        this.entityNamesToProcess = Collections.unmodifiableSet(new HashSet<String>(entityNames));
        if (!old.equals(this.entityNamesToProcess)) {
            List removed = old.stream().filter(oldEntityName -> !this.entityNamesToProcess.contains(oldEntityName)).collect(Collectors.toList());
            List added = this.entityNamesToProcess.stream().filter(newEntityName -> !old.contains(newEntityName)).collect(Collectors.toList());
            log.info("Entity names to process updated. Removed {}. Added {}. Currently processing {}.", new Object[]{removed, added, this.entityNamesToProcess});
        }
        return this;
    }

    @Override
    public Duration getNotificationProcessingTimeout() {
        return this.processingTimeout;
    }

    public MutableLightblueNotificationRepositoryConfig setNotificationProcessingTimeout(Duration notificationProcessingTimeout) {
        Duration old = this.processingTimeout;
        this.processingTimeout = notificationProcessingTimeout;
        if (!old.equals(this.processingTimeout)) {
            log.info("Notification processing timeout updated. Old value was {}. New value is {}.", (Object)old, (Object)this.processingTimeout);
        }
        return this;
    }

    @Override
    public Duration getNotificationExpireThreshold() {
        return this.expireThreshold;
    }

    public MutableLightblueNotificationRepositoryConfig setNotificationExpireThreshold(Duration notificationExpireThreshold) {
        Duration old = this.expireThreshold;
        this.expireThreshold = notificationExpireThreshold;
        if (!old.equals(this.expireThreshold)) {
            log.info("Notification expire threshold updated. Old value was {}. New value is {}.", (Object)old, (Object)this.expireThreshold);
        }
        return this;
    }
}

