/*
 * Decompiled with CFR 0.152.
 */
package org.esbtools.eventhandler.lightblue.config;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.esbtools.eventhandler.lightblue.LightblueDocumentEventRepositoryConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class MutableLightblueDocumentEventRepositoryConfig
implements LightblueDocumentEventRepositoryConfig {
    private Set<String> canonicalTypesToProcess = Collections.emptySet();
    private int documentEventsBatchSize = 0;
    private Optional<Integer> maxDocumentEventsPerInsert = Optional.empty();
    private Duration processingTimeout = Duration.ofMinutes(10L);
    private Duration expireThreshold = Duration.ofMinutes(2L);
    private static final Logger log = LoggerFactory.getLogger(MutableLightblueDocumentEventRepositoryConfig.class);

    public MutableLightblueDocumentEventRepositoryConfig() {
    }

    public MutableLightblueDocumentEventRepositoryConfig(Collection<String> initialCanonicalTypesToProcess, int initialDocumentEventsBatchSize, Duration processingTimeout, Duration expireThreshold) {
        this.canonicalTypesToProcess = Collections.unmodifiableSet(new HashSet<String>(Objects.requireNonNull(initialCanonicalTypesToProcess, "initialCanonicalTypesToProcess")));
        this.documentEventsBatchSize = Objects.requireNonNull(Integer.valueOf(initialDocumentEventsBatchSize), "initialDocumentEventsBatchSize");
        this.processingTimeout = Objects.requireNonNull(processingTimeout, "processingTimeout");
        this.expireThreshold = Objects.requireNonNull(expireThreshold, "expireThreshold");
    }

    public MutableLightblueDocumentEventRepositoryConfig(Collection<String> initialCanonicalTypesToProcess, int initialDocumentEventsBatchSize, Optional<Integer> maxDocumentEventsPerInsert, Duration processingTimeout, Duration expireThreshold) {
        this.canonicalTypesToProcess = Collections.unmodifiableSet(new HashSet<String>(Objects.requireNonNull(initialCanonicalTypesToProcess, "initialCanonicalTypesToProcess")));
        this.documentEventsBatchSize = Objects.requireNonNull(Integer.valueOf(initialDocumentEventsBatchSize), "initialDocumentEventsBatchSize");
        this.maxDocumentEventsPerInsert = maxDocumentEventsPerInsert;
        this.processingTimeout = Objects.requireNonNull(processingTimeout, "processingTimeout");
        this.expireThreshold = Objects.requireNonNull(expireThreshold, "expireThreshold");
    }

    @Override
    public Set<String> getCanonicalTypesToProcess() {
        return this.canonicalTypesToProcess;
    }

    public MutableLightblueDocumentEventRepositoryConfig setCanonicalTypesToProcess(Collection<String> types) {
        Set<String> old = this.canonicalTypesToProcess;
        this.canonicalTypesToProcess = Collections.unmodifiableSet(new HashSet<String>(types));
        if (!old.equals(this.canonicalTypesToProcess)) {
            List removed = old.stream().filter(oldCanonicalType -> !this.canonicalTypesToProcess.contains(oldCanonicalType)).collect(Collectors.toList());
            List added = this.canonicalTypesToProcess.stream().filter(newCanonicalType -> !old.contains(newCanonicalType)).collect(Collectors.toList());
            log.info("Canonical types to process updated. Removed {}. Added {}. Currently processing {}.", new Object[]{removed, added, this.canonicalTypesToProcess});
        }
        return this;
    }

    @Override
    public Integer getDocumentEventsBatchSize() {
        return this.documentEventsBatchSize;
    }

    public MutableLightblueDocumentEventRepositoryConfig setDocumentEventsBatchSize(int batchSize) {
        int old = this.documentEventsBatchSize;
        this.documentEventsBatchSize = batchSize;
        if (old != this.documentEventsBatchSize) {
            log.info("Document event batch size updated. Old value was {}. New value is {}.", (Object)old, (Object)this.documentEventsBatchSize);
        }
        return this;
    }

    @Override
    public Duration getDocumentEventProcessingTimeout() {
        return this.processingTimeout;
    }

    public MutableLightblueDocumentEventRepositoryConfig setDocumentEventProcessingTimeout(Duration processingTimeout) {
        Duration old = this.processingTimeout;
        this.processingTimeout = processingTimeout;
        if (!old.equals(processingTimeout)) {
            log.info("Document event processing timeout updated. Old value was {}. New value is {}.", (Object)old, (Object)processingTimeout);
        }
        return this;
    }

    @Override
    public Duration getDocumentEventExpireThreshold() {
        return this.expireThreshold;
    }

    public MutableLightblueDocumentEventRepositoryConfig setDocumentEventExpireThreshold(Duration expireThreshold) {
        Duration old = this.expireThreshold;
        this.expireThreshold = expireThreshold;
        if (!old.equals(expireThreshold)) {
            log.info("Document event expire threshold updated. Old value was {}. New value is {}.", (Object)old, (Object)expireThreshold);
        }
        return this;
    }

    @Override
    public Optional<Integer> getOptionalMaxDocumentEventsPerInsert() {
        return this.maxDocumentEventsPerInsert;
    }

    public MutableLightblueDocumentEventRepositoryConfig setMaxDocumentEventsPerInsert(Optional<Integer> maxDocumentEventsPerInsert) {
        Optional<Integer> old = this.maxDocumentEventsPerInsert;
        this.maxDocumentEventsPerInsert = maxDocumentEventsPerInsert;
        if (!Objects.equals(old, maxDocumentEventsPerInsert)) {
            log.info("Max document events per insert updated. Old value was {}. New value is {}.", old, maxDocumentEventsPerInsert);
        }
        return this;
    }
}

