/*
 * Decompiled with CFR 0.152.
 */
package org.esbtools.eventhandler.lightblue.client;

import com.redhat.lightblue.client.Literal;
import com.redhat.lightblue.client.Query;
import com.redhat.lightblue.client.Update;
import com.redhat.lightblue.client.request.data.DataUpdateRequest;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Nullable;
import org.esbtools.eventhandler.lightblue.DocumentEventEntity;
import org.esbtools.lightbluenotificationhook.NotificationEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UpdateRequests {
    private static Logger logger = LoggerFactory.getLogger(UpdateRequests.class);

    public static Collection<DataUpdateRequest> notificationsStatusAndProcessedDate(Collection<NotificationEntity> updatedNotificationEntities) {
        ArrayList<DataUpdateRequest> requests = new ArrayList<DataUpdateRequest>(updatedNotificationEntities.size());
        for (NotificationEntity entity : updatedNotificationEntities) {
            DataUpdateRequest request = new DataUpdateRequest("notification", NotificationEntity.ENTITY_VERSION);
            if (entity.get_id() == null) {
                logger.warn("Tried to update an entity's status and processed date, but entity has no id. Entity was: " + entity);
                continue;
            }
            request.where(Query.withValue((String)"_id", (Query.BinOp)Query.BinOp.eq, (Object)entity.get_id()));
            ArrayList<Update.Set> updates = new ArrayList<Update.Set>(2);
            updates.add(Update.set((String)"status", (String)entity.getStatus().toString()));
            Date processedDate = entity.getProcessedDate();
            if (processedDate != null) {
                updates.add(Update.set((String)"processedDate", (Date)processedDate));
            }
            request.updates(updates.toArray(new Update[updates.size()]));
            requests.add(request);
        }
        return requests;
    }

    public static DataUpdateRequest notificationStatusIfCurrent(NotificationEntity entity, @Nullable Date originalProcessingDate) {
        DataUpdateRequest request = new DataUpdateRequest("notification", NotificationEntity.ENTITY_VERSION);
        request.where(Query.and((Query[])new Query[]{Query.withValue((String)"_id", (Query.BinOp)Query.BinOp.eq, (Object)entity.get_id()), Query.withValue((String)"processingDate", (Query.BinOp)Query.BinOp.eq, (Object)originalProcessingDate)}));
        ArrayList<Update.Set> setStatusAndDates = new ArrayList<Update.Set>(3);
        setStatusAndDates.add(Update.set((String)"processingDate", (Date)entity.getProcessingDate()));
        setStatusAndDates.add(Update.set((String)"status", (String)entity.getStatus().toString()));
        if (entity.getProcessedDate() != null) {
            setStatusAndDates.add(Update.set((String)"processedDate", (Date)entity.getProcessedDate()));
        }
        request.updates(setStatusAndDates);
        return request;
    }

    public static Collection<DataUpdateRequest> documentEventsStatusAndProcessedDate(Collection<DocumentEventEntity> updatedEventEntities) {
        ArrayList<DataUpdateRequest> requests = new ArrayList<DataUpdateRequest>(updatedEventEntities.size());
        for (DocumentEventEntity entity : updatedEventEntities) {
            DataUpdateRequest request = new DataUpdateRequest("documentEvent", DocumentEventEntity.VERSION);
            if (entity.get_id() == null) {
                logger.warn("Tried to update an entity's status and processed date, but entity has no id. Entity was: " + entity);
                continue;
            }
            request.where(Query.withValue((String)"_id", (Query.BinOp)Query.BinOp.eq, (Object)entity.get_id()));
            ArrayList<Update.Set> updates = new ArrayList<Update.Set>(2);
            updates.add(Update.set((String)"status", (String)entity.getStatus().toString()));
            ZonedDateTime processedDate = entity.getProcessedDate();
            if (processedDate != null) {
                updates.add(Update.set((String)"processedDate", (Date)Date.from(processedDate.toInstant())));
            }
            request.updates(updates.toArray(new Update[updates.size()]));
            requests.add(request);
        }
        return requests;
    }

    public static DataUpdateRequest documentEventStatusDatesAndSurvivorOfIfCurrent(DocumentEventEntity entity, @Nullable ZonedDateTime originalProcessingDate) {
        DataUpdateRequest request = new DataUpdateRequest("documentEvent", DocumentEventEntity.VERSION);
        ArrayList<Query> idStatusAndDateMatch = new ArrayList<Query>();
        ArrayList<Update.Set> updateStatusDateAndSurvivorOf = new ArrayList<Update.Set>(2);
        ZonedDateTime processedDate = entity.getProcessedDate();
        idStatusAndDateMatch.add(Query.withValue((String)"_id", (Query.BinOp)Query.BinOp.eq, (Object)entity.get_id()));
        if (originalProcessingDate != null) {
            idStatusAndDateMatch.add(Query.withValue((String)"processingDate", (Query.BinOp)Query.BinOp.eq, (Object)Date.from(originalProcessingDate.toInstant())));
            idStatusAndDateMatch.add(Query.withValues((String)"status", (Query.NaryOp)Query.NaryOp.in, (Literal[])Literal.values((String[])new String[]{DocumentEventEntity.Status.processing.toString(), DocumentEventEntity.Status.unprocessed.toString()})));
        } else {
            idStatusAndDateMatch.add(Query.withValue((String)"processingDate", (Query.BinOp)Query.BinOp.eq, (Literal)Literal.value(null)));
            idStatusAndDateMatch.add(Query.withValue((String)"status", (Query.BinOp)Query.BinOp.eq, (Object)DocumentEventEntity.Status.unprocessed.toString()));
        }
        if (processedDate != null) {
            updateStatusDateAndSurvivorOf.add(Update.set((String)"processedDate", (Date)Date.from(processedDate.toInstant())));
        }
        updateStatusDateAndSurvivorOf.add(Update.set((String)"status", (String)entity.getStatus().toString()));
        updateStatusDateAndSurvivorOf.add(Update.set((String)"processingDate", (Date)Date.from(entity.getProcessingDate().toInstant())));
        if (entity.getSurvivorOfIds() != null) {
            String[] survivorOfIds = (String[])entity.getSurvivorOfIds().stream().toArray(String[]::new);
            updateStatusDateAndSurvivorOf.add(Update.set((String)"survivorOfIds", (Update.SetLiteral)Literal.value((Object)Literal.toJson((Literal[])Literal.values((String[])survivorOfIds)))));
        }
        request.where(Query.and(idStatusAndDateMatch));
        request.updates(updateStatusDateAndSurvivorOf);
        return request;
    }
}

