/*
 * Decompiled with CFR 0.152.
 */
package org.esbtools.eventhandler.lightblue.client;

import com.redhat.lightblue.client.Literal;
import com.redhat.lightblue.client.Projection;
import com.redhat.lightblue.client.Query;
import com.redhat.lightblue.client.Sort;
import com.redhat.lightblue.client.request.data.DataFindRequest;
import java.time.Instant;
import java.util.Date;
import org.esbtools.eventhandler.lightblue.DocumentEventEntity;
import org.esbtools.eventhandler.lightblue.config.EventHandlerConfigEntity;
import org.esbtools.lightbluenotificationhook.NotificationEntity;

public abstract class FindRequests {
    public static DataFindRequest oldestNotificationsForEntitiesUpTo(String[] entityNames, int maxNotifications, Instant expiredProcessingDate) {
        DataFindRequest findEntities = new DataFindRequest("notification", NotificationEntity.ENTITY_VERSION);
        findEntities.where(Query.and((Query[])new Query[]{Query.withValue((String)"clientRequestDate", (Query.BinOp)Query.neq, (Literal)Literal.value(null)), Query.withValues((String)"entityName", (Query.NaryOp)Query.NaryOp.in, (Literal[])Literal.values((String[])entityNames)), Query.or((Query[])new Query[]{Query.withValue((String)"status", (Query.BinOp)Query.BinOp.eq, (Object)((Object)DocumentEventEntity.Status.unprocessed)), Query.and((Query[])new Query[]{Query.withValue((String)"status", (Query.BinOp)Query.BinOp.eq, (Object)((Object)DocumentEventEntity.Status.processing)), Query.withValue((String)"processingDate", (Query.BinOp)Query.BinOp.lte, (Object)Date.from(expiredProcessingDate))})})}));
        findEntities.select(new Projection[]{Projection.includeFieldRecursively((String)"*")});
        findEntities.sort(new Sort[]{Sort.asc((String)"clientRequestDate")});
        findEntities.range(Integer.valueOf(0), Integer.valueOf(maxNotifications - 1));
        return findEntities;
    }

    public static DataFindRequest priorityDocumentEventsForTypesUpTo(String[] types, int maxEvents, Instant expiredProcessingDate) {
        DataFindRequest findEntities = new DataFindRequest("documentEvent", DocumentEventEntity.VERSION);
        findEntities.where(Query.and((Query[])new Query[]{Query.withValues((String)"canonicalType", (Query.NaryOp)Query.NaryOp.in, (Literal[])Literal.values((String[])types)), Query.or((Query[])new Query[]{Query.withValue((String)"status", (Query.BinOp)Query.BinOp.eq, (Object)((Object)DocumentEventEntity.Status.unprocessed)), Query.and((Query[])new Query[]{Query.withValue((String)"status", (Query.BinOp)Query.BinOp.eq, (Object)((Object)DocumentEventEntity.Status.processing)), Query.withValue((String)"processingDate", (Query.BinOp)Query.BinOp.lte, (Object)Date.from(expiredProcessingDate))})})}));
        findEntities.select(new Projection[]{Projection.includeFieldRecursively((String)"*")});
        findEntities.sort(new Sort[]{Sort.desc((String)"priority"), Sort.asc((String)"creationDate")});
        findEntities.range(Integer.valueOf(0), Integer.valueOf(maxEvents - 1));
        return findEntities;
    }

    public static DataFindRequest eventHandlerConfigForDomain(String configDomain) {
        DataFindRequest findConfig = new DataFindRequest("eventHandlerConfig", EventHandlerConfigEntity.ENTITY_VERSION);
        findConfig.where(Query.withValue((String)"domain", (Query.BinOp)Query.BinOp.eq, (Object)configDomain));
        findConfig.select(new Projection[]{Projection.includeFieldRecursively((String)"*")});
        return findConfig;
    }
}

