/*
 * Decompiled with CFR 0.152.
 */
package org.esbtools.eventhandler.lightblue.client;

import com.redhat.lightblue.client.LightblueClient;
import com.redhat.lightblue.client.LightblueException;
import com.redhat.lightblue.client.model.DataError;
import com.redhat.lightblue.client.model.Error;
import com.redhat.lightblue.client.request.CRUDRequest;
import com.redhat.lightblue.client.request.DataBulkRequest;
import com.redhat.lightblue.client.request.LightblueRequest;
import com.redhat.lightblue.client.response.LightblueBulkDataResponse;
import com.redhat.lightblue.client.response.LightblueBulkResponseException;
import com.redhat.lightblue.client.response.LightblueDataResponse;
import com.redhat.lightblue.client.response.LightblueErrorResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import org.esbtools.eventhandler.FutureDoneCallback;
import org.esbtools.eventhandler.FutureTransform;
import org.esbtools.eventhandler.NestedTransformableFuture;
import org.esbtools.eventhandler.NestedTransformableFutureIgnoringReturn;
import org.esbtools.eventhandler.Responses;
import org.esbtools.eventhandler.TransformableFuture;
import org.esbtools.eventhandler.lightblue.client.LightblueDataResponses;
import org.esbtools.eventhandler.lightblue.client.LightblueRequester;
import org.esbtools.eventhandler.lightblue.client.LightblueResponse;
import org.esbtools.eventhandler.lightblue.client.LightblueResponseException;
import org.esbtools.eventhandler.lightblue.client.LightblueResponses;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkLightblueRequester
implements LightblueRequester {
    private final LightblueClient lightblue;
    private final boolean ordered;
    private final List<LazyRequestTransformableFuture<LightblueDataResponses>> queuedRequests = Collections.synchronizedList(new ArrayList());
    private final List<LazyRequestTransformableFuture<LightblueResponses>> queuedTryRequests = Collections.synchronizedList(new ArrayList());

    public BulkLightblueRequester(LightblueClient lightblue) {
        this(lightblue, true);
    }

    public BulkLightblueRequester(LightblueClient lightblue, boolean ordered) {
        this.lightblue = lightblue;
        this.ordered = ordered;
    }

    public TransformableFuture<LightblueDataResponses> request(CRUDRequest ... requests) {
        BulkLightblueRequester.checkNoNullsInRequests(requests);
        LazyRequestTransformableFuture<LightblueDataResponses> responseFuture = new LazyRequestTransformableFuture<LightblueDataResponses>(requests);
        this.queuedRequests.add(responseFuture);
        return responseFuture;
    }

    public TransformableFuture<LightblueDataResponses> request(Collection<? extends CRUDRequest> requests) {
        return this.request(requests.toArray(new CRUDRequest[requests.size()]));
    }

    public TransformableFuture<LightblueResponses> tryRequest(CRUDRequest ... req) {
        BulkLightblueRequester.checkNoNullsInRequests(req);
        LazyRequestTransformableFuture<LightblueResponses> responseFuture = new LazyRequestTransformableFuture<LightblueResponses>(req);
        this.queuedTryRequests.add(responseFuture);
        return responseFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doQueuedRequestsAndCompleteFutures() {
        ArrayList<LazyRequestTransformableFuture<LightblueResponses>> tryBatch;
        ArrayList<LazyRequestTransformableFuture<LightblueDataResponses>> batch;
        List<LazyRequestTransformableFuture<Object>> list = this.queuedRequests;
        synchronized (list) {
            batch = new ArrayList<LazyRequestTransformableFuture<LightblueDataResponses>>(this.queuedRequests);
            this.queuedRequests.clear();
        }
        list = this.queuedTryRequests;
        synchronized (list) {
            tryBatch = new ArrayList<LazyRequestTransformableFuture<LightblueResponses>>(this.queuedTryRequests);
            this.queuedTryRequests.clear();
        }
        DataBulkRequest bulkRequest = new DataBulkRequest(this.ordered);
        Stream.concat(batch.stream(), tryBatch.stream()).flatMap(requestFuture -> Arrays.stream(requestFuture.requests)).forEach(arg_0 -> ((DataBulkRequest)bulkRequest).add(arg_0));
        try {
            HashMap<CRUDRequest, LightblueResponse> responseMap;
            CRUDRequest[] requests;
            LightblueBulkDataResponse bulkResponse = this.tryBulkRequest(bulkRequest);
            for (LazyRequestTransformableFuture lazyRequestTransformableFuture : batch) {
                requests = lazyRequestTransformableFuture.requests;
                responseMap = new HashMap<CRUDRequest, LightblueResponse>(requests.length);
                ArrayList<Error> errors = new ArrayList<Error>();
                CRUDRequest[] cRUDRequestArray = requests;
                int n = cRUDRequestArray.length;
                for (int i = 0; i < n; ++i) {
                    CRUDRequest request = cRUDRequestArray[i];
                    LightblueDataResponse response = bulkResponse.getResponse((LightblueRequest)request);
                    if (response instanceof LightblueErrorResponse) {
                        LightblueErrorResponse errorResponse = (LightblueErrorResponse)response;
                        DataError[] dataErrors = errorResponse.getDataErrors();
                        Error[] lightblueErrors = errorResponse.getLightblueErrors();
                        if (dataErrors != null) {
                            for (DataError dataError : dataErrors) {
                                errors.addAll(dataError.getErrors());
                            }
                        }
                        if (lightblueErrors != null) {
                            Collections.addAll(errors, lightblueErrors);
                        }
                    }
                    responseMap.put(request, (LightblueResponse)response);
                }
                if (errors.isEmpty()) {
                    lazyRequestTransformableFuture.complete(new BulkDataResponses((Map<CRUDRequest, LightblueDataResponse>)responseMap));
                    continue;
                }
                lazyRequestTransformableFuture.completeExceptionally(new LightblueResponseException(errors));
            }
            for (LazyRequestTransformableFuture lazyRequestTransformableFuture : tryBatch) {
                requests = lazyRequestTransformableFuture.requests;
                responseMap = new HashMap(requests.length);
                for (CRUDRequest request : requests) {
                    LightblueDataResponse response = bulkResponse.getResponse((LightblueRequest)request);
                    responseMap.put(request, LightblueResponse.fromClientResponse((com.redhat.lightblue.client.response.LightblueResponse)response));
                }
                lazyRequestTransformableFuture.complete(new BulkResponses((Map<CRUDRequest, LightblueResponse>)responseMap));
            }
        }
        catch (Exception e) {
            Stream.concat(batch.stream(), tryBatch.stream()).forEach(batchedFuture -> batchedFuture.completeExceptionally(e));
        }
    }

    private LightblueBulkDataResponse tryBulkRequest(DataBulkRequest bulkRequest) throws LightblueException {
        try {
            return this.lightblue.bulkData(bulkRequest);
        }
        catch (LightblueBulkResponseException e) {
            return e.getBulkResponse();
        }
    }

    private static void checkNoNullsInRequests(CRUDRequest[] requests) {
        Objects.requireNonNull(requests, "requests");
        for (int i = 0; i < requests.length; ++i) {
            Objects.requireNonNull(requests[i], "requests[" + i + "]");
        }
    }

    static interface Completer {
        public void triggerFutureCompletion();
    }

    static class LazyTransformingFuture<T, U>
    implements TransformableFuture<U> {
        private final FutureTransform<T, U> transform;
        private final LazyTransformableFuture<U> backingFuture;

        LazyTransformingFuture(FutureTransform<T, U> transform, Completer completer) {
            this.transform = transform;
            this.backingFuture = new LazyTransformableFuture(completer);
        }

        void complete(T responses) {
            if (this.isDone()) {
                return;
            }
            try {
                Object transformed = this.transform.transform(responses);
                this.backingFuture.complete(transformed);
            }
            catch (Exception e) {
                this.completeExceptionally(e);
            }
        }

        void completeExceptionally(Exception exception) {
            this.backingFuture.completeExceptionally(exception);
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.backingFuture.cancel(mayInterruptIfRunning);
        }

        public boolean isCancelled() {
            return this.backingFuture.isCancelled();
        }

        public boolean isDone() {
            return this.backingFuture.isDone();
        }

        public U get() throws InterruptedException, ExecutionException {
            return this.backingFuture.get();
        }

        public U get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.backingFuture.get(timeout, unit);
        }

        public <V> TransformableFuture<V> transformSync(FutureTransform<U, V> futureTransform) {
            return this.backingFuture.transformSync(futureTransform);
        }

        public <V> TransformableFuture<V> transformAsync(FutureTransform<U, TransformableFuture<V>> futureTransform) {
            return this.backingFuture.transformAsync(futureTransform);
        }

        public TransformableFuture<Void> transformAsyncIgnoringReturn(FutureTransform<U, TransformableFuture<?>> futureTransform) {
            return this.backingFuture.transformAsyncIgnoringReturn(futureTransform);
        }

        public TransformableFuture<U> whenDoneOrCancelled(FutureDoneCallback callback) {
            this.backingFuture.whenDoneOrCancelled(callback);
            return this;
        }
    }

    class LazyRequestTransformableFuture<T>
    implements TransformableFuture<T> {
        private final LazyTransformableFuture<T> backingFuture = new LazyTransformableFuture(() -> BulkLightblueRequester.access$200(BulkLightblueRequester.this));
        final CRUDRequest[] requests;

        LazyRequestTransformableFuture(CRUDRequest[] requests) {
            this.requests = requests;
        }

        void complete(T responses) {
            this.backingFuture.complete(responses);
        }

        void completeExceptionally(Exception exception) {
            this.backingFuture.completeExceptionally(exception);
        }

        public <U> TransformableFuture<U> transformSync(FutureTransform<T, U> futureTransform) {
            return this.backingFuture.transformSync(futureTransform);
        }

        public <U> TransformableFuture<U> transformAsync(FutureTransform<T, TransformableFuture<U>> futureTransform) {
            return this.backingFuture.transformAsync(futureTransform);
        }

        public TransformableFuture<Void> transformAsyncIgnoringReturn(FutureTransform<T, TransformableFuture<?>> futureTransform) {
            return this.backingFuture.transformAsyncIgnoringReturn(futureTransform);
        }

        public TransformableFuture<T> whenDoneOrCancelled(FutureDoneCallback callback) {
            this.backingFuture.whenDoneOrCancelled(callback);
            return this;
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            if (!this.backingFuture.isDone()) {
                BulkLightblueRequester.this.queuedRequests.remove(this);
                BulkLightblueRequester.this.queuedTryRequests.remove(this);
            }
            return this.backingFuture.cancel(mayInterruptIfRunning);
        }

        public boolean isCancelled() {
            return this.backingFuture.isCancelled();
        }

        public boolean isDone() {
            return this.backingFuture.isDone();
        }

        public T get() throws InterruptedException, ExecutionException {
            return this.backingFuture.get();
        }

        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.backingFuture.get(timeout, unit);
        }
    }

    static class LazyTransformableFuture<U>
    implements TransformableFuture<U> {
        private final Completer completer;
        private U result;
        private Exception exception;
        private boolean completed = false;
        private boolean cancelled = false;
        private final List<LazyTransformingFuture<U, ?>> next = new ArrayList(1);
        private final List<FutureDoneCallback> doneCallbacks = new ArrayList<FutureDoneCallback>();
        private static Logger log = LoggerFactory.getLogger(LazyTransformableFuture.class);

        LazyTransformableFuture(Completer completer) {
            this.completer = completer;
        }

        void complete(U responses) {
            if (this.isDone()) {
                return;
            }
            this.result = responses;
            this.completed = true;
            this.callDoneCallbacks();
            for (LazyTransformingFuture<U, ?> next : this.next) {
                try {
                    next.complete(this.result);
                }
                catch (Exception e) {
                    log.warn("Exception caught and ignored while completing next transforming future.", (Throwable)e);
                }
            }
        }

        void completeExceptionally(Exception exception) {
            if (this.isDone()) {
                return;
            }
            this.completed = true;
            this.exception = exception;
            this.callDoneCallbacks();
            for (LazyTransformingFuture<U, ?> next : this.next) {
                try {
                    next.completeExceptionally(exception);
                }
                catch (Exception e) {
                    log.warn("Exception caught and ignored while completing next transforming future with exception.", (Throwable)e);
                }
            }
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            if (this.completed) {
                return false;
            }
            this.cancelled = true;
            this.callDoneCallbacks();
            return true;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public boolean isDone() {
            return this.cancelled || this.completed;
        }

        public U get() throws InterruptedException, ExecutionException {
            try {
                return this.get(Optional.empty());
            }
            catch (TimeoutException e) {
                throw new ExecutionException("A future without a timeout is attempting to throw a TimeoutException while it should not. This implies there is a bug in the future code and will need to be corrected ", e);
            }
        }

        public U get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.get(Optional.of(new TimeoutDuration(timeout, unit)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private U get(Optional<TimeoutDuration> timeout) throws TimeoutException, InterruptedException, ExecutionException {
            if (this.cancelled) {
                throw new CancellationException();
            }
            if (!this.completed) {
                if (timeout.isPresent()) {
                    ExecutorService executor = Executors.newSingleThreadExecutor();
                    try {
                        Future<?> submittedTask = executor.submit(() -> this.completer.triggerFutureCompletion());
                        TimeoutDuration timeoutDuration = timeout.get();
                        submittedTask.get(timeoutDuration.duration, timeoutDuration.timeUnit);
                    }
                    finally {
                        executor.shutdownNow();
                    }
                } else {
                    this.completer.triggerFutureCompletion();
                }
                if (!this.completed) {
                    throw new ExecutionException(new IllegalStateException("Future attempted to lazily trigger completion, but completer did not actually complete the future. Check the provided completer function for correctness."));
                }
            }
            if (this.exception != null) {
                throw new ExecutionException(this.exception);
            }
            return this.result;
        }

        public <V> TransformableFuture<V> transformSync(FutureTransform<U, V> futureTransform) {
            LazyTransformingFuture<U, V> future = new LazyTransformingFuture<U, V>(futureTransform, this.completer);
            this.next.add(future);
            return future;
        }

        public <V> TransformableFuture<V> transformAsync(FutureTransform<U, TransformableFuture<V>> futureTransform) {
            LazyTransformingFuture<U, TransformableFuture<V>> future = new LazyTransformingFuture<U, TransformableFuture<V>>(futureTransform, this.completer);
            this.next.add(future);
            return new NestedTransformableFuture(future);
        }

        public TransformableFuture<Void> transformAsyncIgnoringReturn(FutureTransform<U, TransformableFuture<?>> futureTransform) {
            LazyTransformingFuture future = new LazyTransformingFuture(futureTransform, this.completer);
            this.next.add(future);
            return new NestedTransformableFutureIgnoringReturn(future);
        }

        public TransformableFuture<U> whenDoneOrCancelled(FutureDoneCallback callback) {
            if (this.isDone()) {
                try {
                    callback.onDoneOrCancelled();
                }
                catch (Exception e) {
                    log.warn("Exception caught and ignored while running future done callback.", (Throwable)e);
                }
                return this;
            }
            this.doneCallbacks.add(callback);
            return this;
        }

        private void callDoneCallbacks() {
            for (FutureDoneCallback doneCallback : this.doneCallbacks) {
                try {
                    doneCallback.onDoneOrCancelled();
                }
                catch (Exception e) {
                    log.warn("Exception caught and ignored while running future done callback.", (Throwable)e);
                }
            }
        }

        private static class TimeoutDuration {
            final long duration;
            final TimeUnit timeUnit;

            TimeoutDuration(long duration, TimeUnit timeUnit) {
                this.duration = duration;
                this.timeUnit = timeUnit;
            }
        }
    }

    static class BulkResponses
    extends ResponseMap<LightblueResponse>
    implements LightblueResponses {
        BulkResponses(Map<CRUDRequest, LightblueResponse> responseMap) {
            super(responseMap);
        }
    }

    static class BulkDataResponses
    extends ResponseMap<LightblueDataResponse>
    implements LightblueDataResponses {
        BulkDataResponses(Map<CRUDRequest, LightblueDataResponse> responseMap) {
            super(responseMap);
        }
    }

    static abstract class ResponseMap<T>
    implements Responses<CRUDRequest, T> {
        private final Map<CRUDRequest, T> responseMap;

        ResponseMap(Map<CRUDRequest, T> responseMap) {
            this.responseMap = responseMap;
        }

        public T forRequest(CRUDRequest request) {
            if (this.responseMap.containsKey(request)) {
                return this.responseMap.get(request);
            }
            throw new NoSuchElementException("No response for request: " + request);
        }
    }
}

