/*
 * Decompiled with CFR 0.152.
 */
package org.esbtools.eventhandler.lightblue;

import com.redhat.lightblue.client.LightblueClient;
import com.redhat.lightblue.client.Query;
import com.redhat.lightblue.client.request.LightblueDataRequest;
import com.redhat.lightblue.client.request.data.DataDeleteRequest;
import com.redhat.lightblue.client.response.LightblueDataResponse;
import java.sql.Date;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spi.RoutePolicy;
import org.esbtools.eventhandler.lightblue.DocumentEventEntity;
import org.esbtools.eventhandler.lightblue.locking.LockStrategy;
import org.esbtools.eventhandler.lightblue.locking.LockingRoutePolicy;
import org.esbtools.lightbluenotificationhook.NotificationEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodicDeleteOldEntitiesRoute
extends RouteBuilder {
    private final LightblueClient client;
    private final LockStrategy lockStrategy;
    private final Duration deleteOlderThan;
    private final Duration deleteInterval;
    private final Clock clock;
    private final String entityName;
    private final String entityVersion;
    private final String entityDateField;
    final String deleterLockResourceId;
    private static final Logger log = LoggerFactory.getLogger(PeriodicDeleteOldEntitiesRoute.class);

    public static PeriodicDeleteOldEntitiesRoute deletingNotificationsOlderThan(Duration deleteOlderThan, Duration deleteInterval, LightblueClient client, LockStrategy lockStrategy, Clock clock) {
        return new PeriodicDeleteOldEntitiesRoute("notification", NotificationEntity.ENTITY_VERSION, "clientRequestDate", client, lockStrategy, deleteOlderThan, deleteInterval, clock);
    }

    public static PeriodicDeleteOldEntitiesRoute deletingDocumentEventsOlderThan(Duration deleteOlderThan, Duration deleteInterval, LightblueClient client, LockStrategy lockStrategy, Clock clock) {
        return new PeriodicDeleteOldEntitiesRoute("documentEvent", DocumentEventEntity.VERSION, "creationDate", client, lockStrategy, deleteOlderThan, deleteInterval, clock);
    }

    public PeriodicDeleteOldEntitiesRoute(String entityName, String entityVersion, String entityDateField, LightblueClient client, LockStrategy lockStrategy, Duration deleteOlderThan, Duration deleteInterval, Clock clock) {
        this.client = client;
        this.lockStrategy = lockStrategy;
        this.deleteOlderThan = deleteOlderThan;
        this.deleteInterval = deleteInterval;
        this.clock = clock;
        this.entityName = entityName;
        this.entityVersion = entityVersion;
        this.entityDateField = entityDateField;
        this.deleterLockResourceId = "old_" + entityName + "_deleter";
    }

    public void configure() throws Exception {
        this.from("timer:" + this.deleterLockResourceId + "?period=" + this.deleteInterval.toMillis()).routeId(this.deleterLockResourceId).routePolicy(new RoutePolicy[]{new LockingRoutePolicy(this.deleterLockResourceId, this.lockStrategy)}).process(exchange -> {
            Instant tooOld = this.clock.instant().minus(this.deleteOlderThan);
            log.debug("Deleting {} entities with {} before {}", new Object[]{this.entityName, this.entityDateField, tooOld});
            DataDeleteRequest deleteRequest = new DataDeleteRequest(this.entityName, this.entityVersion);
            deleteRequest.where(Query.withValue((String)this.entityDateField, (Query.BinOp)Query.BinOp.lt, (Object)Date.from(tooOld)));
            LightblueDataResponse response = this.client.data((LightblueDataRequest)deleteRequest);
            log.info("Deleted {} {} entities with {} before {}", new Object[]{response.parseModifiedCount(), this.entityName, this.entityDateField, tooOld});
        });
    }
}

