/*
 * Decompiled with CFR 0.152.
 */
package org.esbtools.eventhandler.lightblue;

import com.redhat.lightblue.client.LightblueClient;
import com.redhat.lightblue.client.LightblueException;
import com.redhat.lightblue.client.request.CRUDRequest;
import com.redhat.lightblue.client.request.DataBulkRequest;
import com.redhat.lightblue.client.request.LightblueDataRequest;
import com.redhat.lightblue.client.response.LightblueBulkDataResponse;
import com.redhat.lightblue.client.response.LightblueBulkResponseException;
import com.redhat.lightblue.client.response.LightblueDataResponse;
import com.redhat.lightblue.client.response.LightblueResponse;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.esbtools.eventhandler.FailedNotification;
import org.esbtools.eventhandler.Notification;
import org.esbtools.eventhandler.NotificationRepository;
import org.esbtools.eventhandler.lightblue.LightblueNotification;
import org.esbtools.eventhandler.lightblue.LightblueNotificationRepositoryConfig;
import org.esbtools.eventhandler.lightblue.NotificationFactory;
import org.esbtools.eventhandler.lightblue.ProcessingExpiredException;
import org.esbtools.eventhandler.lightblue.UnparseableNotification;
import org.esbtools.eventhandler.lightblue.client.BulkLightblueRequester;
import org.esbtools.eventhandler.lightblue.client.FindRequests;
import org.esbtools.eventhandler.lightblue.client.LightblueErrors;
import org.esbtools.eventhandler.lightblue.client.LightblueRequester;
import org.esbtools.eventhandler.lightblue.client.UpdateRequests;
import org.esbtools.lightbluenotificationhook.NotificationEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightblueNotificationRepository
implements NotificationRepository {
    private final LightblueClient lightblue;
    private final LightblueNotificationRepositoryConfig config;
    private final Map<String, NotificationFactory> notificationFactoryByEntityName;
    private final Clock clock;
    private final Set<String> supportedEntityNames;
    private final String[] supportedEntityNamesArray;
    private static final Logger logger = LoggerFactory.getLogger(LightblueNotificationRepository.class);

    public LightblueNotificationRepository(LightblueClient lightblue, LightblueNotificationRepositoryConfig config, Map<String, NotificationFactory> notificationFactoryByEntityName, Clock clock) {
        this.lightblue = lightblue;
        this.config = config;
        this.notificationFactoryByEntityName = notificationFactoryByEntityName;
        this.clock = clock;
        this.supportedEntityNames = notificationFactoryByEntityName.keySet();
        this.supportedEntityNamesArray = this.supportedEntityNames.toArray(new String[this.supportedEntityNames.size()]);
    }

    public List<LightblueNotification> retrieveOldestNotificationsUpTo(int maxNotifications) throws Exception {
        LightblueBulkDataResponse bulkResponse;
        Object[] entitiesToProcess = this.getSupportedAndEnabledEntityNames();
        Duration processingTimeout = this.config.getNotificationProcessingTimeout();
        if (entitiesToProcess.length == 0) {
            logger.info("Not retrieving any notifications because either there are no enabled or supported entity names to process. Supported entity names are {}. Of those, enabled entity names are {}", this.supportedEntityNames, (Object)Arrays.toString(entitiesToProcess));
            return Collections.emptyList();
        }
        if (maxNotifications == 0) {
            return Collections.emptyList();
        }
        NotificationEntity[] notificationEntities = (NotificationEntity[])this.lightblue.data((LightblueDataRequest)FindRequests.oldestNotificationsForEntitiesUpTo((String[])entitiesToProcess, maxNotifications, this.clock.instant().minus(processingTimeout))).parseProcessed(NotificationEntity[].class);
        List<ProcessingNotification> processingList = ProcessingNotification.parseNotificationEntities(notificationEntities, new BulkLightblueRequester(this.lightblue), this.notificationFactoryByEntityName, this.clock);
        if (processingList.isEmpty()) {
            return Collections.emptyList();
        }
        DataBulkRequest updateEntities = new DataBulkRequest();
        ArrayList<LightblueNotification> updatedNotifications = new ArrayList<LightblueNotification>(processingList.size());
        for (ProcessingNotification processing : processingList) {
            updateEntities.add((CRUDRequest)UpdateRequests.notificationStatusIfCurrent(processing.notification.wrappedNotificationEntity(), processing.originalProcessingDate));
            updatedNotifications.add(processing.notification);
        }
        try {
            bulkResponse = this.lightblue.bulkData(updateEntities);
        }
        catch (LightblueBulkResponseException e) {
            bulkResponse = e.getBulkResponse();
        }
        Iterator notificationsIterator = updatedNotifications.iterator();
        Iterator responsesIterator = bulkResponse.getResponses().iterator();
        while (notificationsIterator.hasNext()) {
            if (!responsesIterator.hasNext()) {
                throw new IllegalStateException("Mismatched number of requests and responses! Notifications looked like: " + updatedNotifications + "Responses looked like: " + bulkResponse.getResponses());
            }
            LightblueDataResponse response = (LightblueDataResponse)responsesIterator.next();
            LightblueNotification notification = (LightblueNotification)notificationsIterator.next();
            if (LightblueErrors.arePresentInResponse((LightblueResponse)response)) {
                if (logger.isWarnEnabled()) {
                    List<String> errorStrings = LightblueErrors.toStringsFromErrorResponse((LightblueResponse)response);
                    logger.warn("Notification update failed. Will not process. Event was: <{}>. Errors: <{}>", (Object)notification, errorStrings);
                }
                notificationsIterator.remove();
                continue;
            }
            if (response.parseModifiedCount() != 0) continue;
            logger.warn("Notification updated by another thread. Will not process. Notification id: {}", (Object)notification.wrappedNotificationEntity().get_id());
            notificationsIterator.remove();
        }
        return updatedNotifications;
    }

    public void ensureTransactionActive(Notification notification) throws Exception {
        if (!(notification instanceof LightblueNotification)) {
            throw new IllegalArgumentException("Unknown event type. Only LightblueDocumentEvent is supported. Event type was: " + notification.getClass());
        }
        LightblueNotification lightblueNotification = (LightblueNotification)notification;
        Duration processingTimeout = this.config.getNotificationProcessingTimeout();
        Duration expireThreshold = this.config.getNotificationExpireThreshold();
        Instant processingDate = lightblueNotification.wrappedNotificationEntity().getProcessingDate().toInstant();
        Instant expireDate = processingDate.plus(processingTimeout).minus(expireThreshold);
        if (this.clock.instant().isAfter(expireDate)) {
            throw new ProcessingExpiredException(notification, processingTimeout, expireThreshold);
        }
    }

    public void markNotificationsProcessedOrFailed(Collection<? extends Notification> notification, Collection<FailedNotification> failures) throws LightblueException {
        List<NotificationEntity> processedNotificationEntities = notification.stream().map(LightblueNotificationRepository::asEntity).peek(entity -> {
            entity.setStatus(NotificationEntity.Status.processed);
            entity.setProcessedDate(Date.from(this.clock.instant()));
        }).collect(Collectors.toList());
        List<NotificationEntity> failedNotificationEntities = failures.stream().map(FailedNotification::notification).map(LightblueNotificationRepository::asEntity).peek(entity -> {
            entity.setStatus(NotificationEntity.Status.failed);
            entity.setProcessedDate(Date.from(this.clock.instant()));
        }).collect(Collectors.toList());
        DataBulkRequest markNotifications = new DataBulkRequest();
        markNotifications.addAll(UpdateRequests.notificationsStatusAndProcessedDate(processedNotificationEntities));
        markNotifications.addAll(UpdateRequests.notificationsStatusAndProcessedDate(failedNotificationEntities));
        if (markNotifications.getRequests().isEmpty()) {
            return;
        }
        this.lightblue.bulkData(markNotifications);
    }

    private String[] getSupportedAndEnabledEntityNames() {
        Set<String> entityNamesToProcess = this.config.getEntityNamesToProcess();
        if (entityNamesToProcess == null) {
            return new String[0];
        }
        if (entityNamesToProcess.containsAll(this.supportedEntityNames)) {
            return this.supportedEntityNamesArray;
        }
        ArrayList<String> supportedAndEnabled = new ArrayList<String>(this.supportedEntityNames);
        supportedAndEnabled.retainAll(entityNamesToProcess);
        return supportedAndEnabled.toArray(new String[supportedAndEnabled.size()]);
    }

    private static NotificationEntity asEntity(Notification notification) {
        if (notification instanceof LightblueNotification) {
            return ((LightblueNotification)notification).wrappedNotificationEntity();
        }
        throw new IllegalArgumentException("Unknown notification type. Only LightblueNotification is supported. Event type was: " + notification.getClass());
    }

    static class ProcessingNotification {
        final String notificationId;
        final Date originalProcessingDate;
        final LightblueNotification notification;

        static List<ProcessingNotification> parseNotificationEntities(NotificationEntity[] entities, LightblueRequester requester, Map<String, ? extends NotificationFactory> notificationFactoriesByEntityName, Clock clock) {
            ArrayList<ProcessingNotification> processedNotifications = new ArrayList<ProcessingNotification>(entities.length);
            List<NotificationEntity> notificationEntityList = Arrays.asList(entities);
            for (NotificationEntity entity : notificationEntityList) {
                LightblueNotification notification;
                try {
                    notification = notificationFactoriesByEntityName.get(entity.getEntityName()).getNotificationForEntity(entity, requester);
                }
                catch (Exception e) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Failed to parse notification entity: " + entity, (Throwable)e);
                    }
                    notification = new UnparseableNotification(e, entity);
                }
                Date originalProcessingDate = entity.getProcessingDate();
                ProcessingNotification processing = new ProcessingNotification(entity.get_id(), notification, originalProcessingDate);
                processedNotifications.add(processing);
                entity.setProcessingDate(Date.from(clock.instant()));
                entity.setStatus(NotificationEntity.Status.processing);
            }
            return processedNotifications;
        }

        private ProcessingNotification(String notificationId, LightblueNotification notification, Date originalProcessingDate) {
            this.notificationId = notificationId;
            this.notification = notification;
            this.originalProcessingDate = originalProcessingDate;
        }

        public String toString() {
            return "ProcessingNotification{originalProcessingDate=" + this.originalProcessingDate + ", notification=" + this.notification + ", notificationId='" + this.notificationId + '\'' + '}';
        }
    }
}

