/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.loader.parser;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import jakarta.xml.bind.JAXBElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.entur.netex.index.api.NetexEntitiesIndex;
import org.entur.netex.index.api.NetexEntityIndex;
import org.entur.netex.loader.parser.NetexParser;
import org.entur.netex.loader.parser.NoticeParser;
import org.rutebanken.netex.model.DestinationDisplay;
import org.rutebanken.netex.model.DestinationDisplaysInFrame_RelStructure;
import org.rutebanken.netex.model.FlexibleLine;
import org.rutebanken.netex.model.FlexibleStopAssignment;
import org.rutebanken.netex.model.FlexibleStopPlace;
import org.rutebanken.netex.model.GroupOfLines;
import org.rutebanken.netex.model.GroupsOfLinesInFrame_RelStructure;
import org.rutebanken.netex.model.JourneyPattern;
import org.rutebanken.netex.model.JourneyPatternsInFrame_RelStructure;
import org.rutebanken.netex.model.Line;
import org.rutebanken.netex.model.LinesInFrame_RelStructure;
import org.rutebanken.netex.model.Network;
import org.rutebanken.netex.model.NetworksInFrame_RelStructure;
import org.rutebanken.netex.model.PassengerStopAssignment;
import org.rutebanken.netex.model.QuayRefStructure;
import org.rutebanken.netex.model.Route;
import org.rutebanken.netex.model.RoutePoint;
import org.rutebanken.netex.model.RoutePointsInFrame_RelStructure;
import org.rutebanken.netex.model.RoutesInFrame_RelStructure;
import org.rutebanken.netex.model.ScheduledStopPoint;
import org.rutebanken.netex.model.ScheduledStopPointRefStructure;
import org.rutebanken.netex.model.ScheduledStopPointsInFrame_RelStructure;
import org.rutebanken.netex.model.ServiceJourneyPattern;
import org.rutebanken.netex.model.ServiceLink;
import org.rutebanken.netex.model.ServiceLinksInFrame_RelStructure;
import org.rutebanken.netex.model.Service_VersionFrameStructure;
import org.rutebanken.netex.model.StopAssignmentsInFrame_RelStructure;
import org.rutebanken.netex.model.StopPlaceRefStructure;
import org.rutebanken.netex.model.VersionFrame_VersionStructure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceFrameParser
extends NetexParser<Service_VersionFrameStructure> {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceFrameParser.class);
    private final NetexEntityIndex<FlexibleStopPlace> flexibleStopPlaceById;
    private final Collection<Network> networks = new ArrayList<Network>();
    private final Collection<GroupOfLines> groupOfLines = new ArrayList<GroupOfLines>();
    private final Collection<Route> routes = new ArrayList<Route>();
    private final Collection<FlexibleLine> flexibleLines = new ArrayList<FlexibleLine>();
    private final Collection<Line> lines = new ArrayList<Line>();
    private final Map<String, String> networkIdByGroupOfLineId = new HashMap<String, String>();
    private final Collection<JourneyPattern> journeyPatterns = new ArrayList<JourneyPattern>();
    private final Collection<ServiceJourneyPattern> serviceJourneyPatterns = new ArrayList<ServiceJourneyPattern>();
    private final Collection<DestinationDisplay> destinationDisplays = new ArrayList<DestinationDisplay>();
    private final Map<String, String> quayIdByStopPointRef = new HashMap<String, String>();
    private final Map<String, String> stopPlaceIdByStopPointRef = new HashMap<String, String>();
    private final Map<String, String> flexibleStopPlaceByStopPointRef = new HashMap<String, String>();
    private final Collection<ServiceLink> serviceLinks = new ArrayList<ServiceLink>();
    private final Collection<ScheduledStopPoint> scheduledStopPoints = new ArrayList<ScheduledStopPoint>();
    private final Collection<RoutePoint> routePoints = new ArrayList<RoutePoint>();
    private final Multimap<String, PassengerStopAssignment> passengerStopAssignmentByStopPointRef = ArrayListMultimap.create();
    private final NoticeParser noticeParser = new NoticeParser();

    ServiceFrameParser(NetexEntityIndex<FlexibleStopPlace> flexibleStopPlaceById) {
        this.flexibleStopPlaceById = flexibleStopPlaceById;
    }

    @Override
    void parse(Service_VersionFrameStructure frame) {
        this.parseStopAssignments(frame.getStopAssignments());
        this.parseRoutes(frame.getRoutes());
        this.parseNetwork(frame.getNetwork());
        this.parseAdditionalNetworks(frame.getAdditionalNetworks());
        this.noticeParser.parseNotices(frame.getNotices());
        this.noticeParser.parseNoticeAssignments(frame.getNoticeAssignments());
        this.parseLines(frame.getLines());
        this.parseJourneyPatterns(frame.getJourneyPatterns());
        this.parseDestinationDisplays(frame.getDestinationDisplays());
        this.parseServiceLinks(frame.getServiceLinks());
        this.parseScheduledStopPoints(frame.getScheduledStopPoints());
        this.parseRoutePoints(frame.getRoutePoints());
        ServiceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getCommonSections());
        ServiceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getConnections());
        ServiceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getDirections());
        ServiceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getDisplayAssignments());
        ServiceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getFlexibleLinkProperties());
        ServiceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getFlexiblePointProperties());
        ServiceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getGeneralSections());
        ServiceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getGroupsOfLines());
        ServiceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getGroupsOfLinks());
        ServiceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getGroupsOfPoints());
        ServiceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getLineNetworks());
        ServiceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getLogicalDisplays());
        ServiceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getPassengerInformationEquipments());
        ServiceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getRouteLinks());
        ServiceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getRoutingConstraintZones());
        ServiceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getServiceExclusions());
        ServiceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getServicePatterns());
        ServiceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getStopAreas());
        ServiceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getTariffZones());
        ServiceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getTimeDemandTypes());
        ServiceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getTimeDemandTypeAssignments());
        ServiceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getTimingPoints());
        ServiceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getTimingLinks());
        ServiceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getTimingLinkGroups());
        ServiceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getTimingPatterns());
        ServiceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getTransferRestrictions());
        ServiceFrameParser.verifyCommonUnusedPropertiesIsNotSet(LOG, (VersionFrame_VersionStructure)frame);
    }

    @Override
    void setResultOnIndex(NetexEntitiesIndex index) {
        index.getDestinationDisplayIndex().putAll(this.destinationDisplays);
        index.getGroupOfLinesIndex().putAll(this.groupOfLines);
        index.getJourneyPatternIndex().putAll(this.journeyPatterns);
        index.getServiceJourneyPatternIndex().putAll(this.serviceJourneyPatterns);
        index.getFlexibleLineIndex().putAll(this.flexibleLines);
        index.getLineIndex().putAll(this.lines);
        index.getNetworkIndex().putAll(this.networks);
        this.noticeParser.setResultOnIndex(index);
        index.getQuayIdByStopPointRefIndex().putAll(this.quayIdByStopPointRef);
        index.getStopPlaceIdByStopPointRefIndex().putAll(this.stopPlaceIdByStopPointRef);
        index.getFlexibleStopPlaceIdByStopPointRefIndex().putAll(this.flexibleStopPlaceByStopPointRef);
        index.getRouteIndex().putAll(this.routes);
        index.getServiceLinkIndex().putAll(this.serviceLinks);
        index.getScheduledStopPointIndex().putAll(this.scheduledStopPoints);
        index.getRoutePointIndex().putAll(this.routePoints);
        index.getPassengerStopAssignmentsByStopPointRefIndex().putAll(this.passengerStopAssignmentByStopPointRef);
        index.getNetworkIdByGroupOfLineIdIndex().putAll(this.networkIdByGroupOfLineId);
    }

    private void parseStopAssignments(StopAssignmentsInFrame_RelStructure stopAssignments) {
        if (stopAssignments == null) {
            return;
        }
        for (JAXBElement stopAssignment : stopAssignments.getStopAssignment()) {
            PassengerStopAssignment assignment;
            if (stopAssignment.getValue() instanceof PassengerStopAssignment) {
                assignment = (PassengerStopAssignment)stopAssignment.getValue();
                String stopPointRef = ((ScheduledStopPointRefStructure)assignment.getScheduledStopPointRef().getValue()).getRef();
                this.passengerStopAssignmentByStopPointRef.put((Object)stopPointRef, (Object)assignment);
                if (assignment.getQuayRef() != null) {
                    String quayRef = ((QuayRefStructure)assignment.getQuayRef().getValue()).getRef();
                    this.quayIdByStopPointRef.put(stopPointRef, quayRef);
                }
                if (assignment.getStopPlaceRef() == null) continue;
                String stopPlaceRef = ((StopPlaceRefStructure)assignment.getStopPlaceRef().getValue()).getRef();
                this.stopPlaceIdByStopPointRef.put(stopPointRef, stopPlaceRef);
                continue;
            }
            if (!(stopAssignment.getValue() instanceof FlexibleStopAssignment)) continue;
            assignment = (FlexibleStopAssignment)stopAssignment.getValue();
            String flexibleStopPlaceRef = assignment.getFlexibleStopPlaceRef().getRef();
            FlexibleStopPlace flexibleStopPlace = this.flexibleStopPlaceById.get(flexibleStopPlaceRef);
            if (flexibleStopPlace != null) {
                String stopPointRef = ((ScheduledStopPointRefStructure)assignment.getScheduledStopPointRef().getValue()).getRef();
                this.flexibleStopPlaceByStopPointRef.put(stopPointRef, flexibleStopPlace.getId());
                continue;
            }
            LOG.warn("FlexibleStopPlace {} not found in stop place file.", (Object)flexibleStopPlaceRef);
        }
    }

    private void parseRoutes(RoutesInFrame_RelStructure routes) {
        if (routes == null) {
            return;
        }
        for (JAXBElement element : routes.getRoute_()) {
            Object object = element.getValue();
            if (!(object instanceof Route)) continue;
            Route route = (Route)object;
            this.routes.add(route);
        }
    }

    private void parseNetwork(Network network) {
        if (network == null) {
            return;
        }
        this.networks.add(network);
        GroupsOfLinesInFrame_RelStructure groupsOfLines = network.getGroupsOfLines();
        if (groupsOfLines != null) {
            this.parseGroupOfLines(groupsOfLines.getGroupOfLines(), network);
        }
    }

    private void parseAdditionalNetworks(NetworksInFrame_RelStructure additionalNetworks) {
        if (additionalNetworks == null) {
            return;
        }
        for (Network additionalNetwork : additionalNetworks.getNetwork()) {
            this.parseNetwork(additionalNetwork);
        }
    }

    private void parseGroupOfLines(Collection<GroupOfLines> groupOfLines, Network network) {
        for (GroupOfLines group : groupOfLines) {
            this.networkIdByGroupOfLineId.put(group.getId(), network.getId());
            this.groupOfLines.add(group);
        }
    }

    private void parseLines(LinesInFrame_RelStructure lines) {
        if (lines == null) {
            return;
        }
        for (JAXBElement element : lines.getLine_()) {
            if (element.getValue() instanceof Line) {
                this.lines.add((Line)element.getValue());
                continue;
            }
            if (element.getValue() instanceof FlexibleLine) {
                this.flexibleLines.add((FlexibleLine)element.getValue());
                continue;
            }
            ServiceFrameParser.informOnElementIntentionallySkipped(LOG, element.getValue());
        }
    }

    private void parseJourneyPatterns(JourneyPatternsInFrame_RelStructure journeyPatterns) {
        if (journeyPatterns == null) {
            return;
        }
        for (JAXBElement pattern : journeyPatterns.getJourneyPattern_OrJourneyPatternView()) {
            if (pattern.getValue() instanceof JourneyPattern) {
                this.journeyPatterns.add((JourneyPattern)pattern.getValue());
                continue;
            }
            if (pattern.getValue() instanceof ServiceJourneyPattern) {
                this.serviceJourneyPatterns.add((ServiceJourneyPattern)pattern.getValue());
                continue;
            }
            ServiceFrameParser.informOnElementIntentionallySkipped(LOG, pattern.getValue());
        }
    }

    private void parseDestinationDisplays(DestinationDisplaysInFrame_RelStructure destDisplays) {
        if (destDisplays == null) {
            return;
        }
        this.destinationDisplays.addAll(destDisplays.getDestinationDisplay());
    }

    private void parseServiceLinks(ServiceLinksInFrame_RelStructure serviceLinks) {
        if (serviceLinks == null) {
            return;
        }
        this.serviceLinks.addAll(serviceLinks.getServiceLink());
    }

    private void parseScheduledStopPoints(ScheduledStopPointsInFrame_RelStructure scheduledStopPoints) {
        if (scheduledStopPoints == null) {
            return;
        }
        this.scheduledStopPoints.addAll(scheduledStopPoints.getScheduledStopPoint());
    }

    private void parseRoutePoints(RoutePointsInFrame_RelStructure routePoints) {
        if (routePoints == null) {
            return;
        }
        this.routePoints.addAll(routePoints.getRoutePoint());
    }
}

