/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.loader.parser;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import jakarta.xml.bind.JAXBElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.entur.netex.index.api.NetexEntitiesIndex;
import org.entur.netex.loader.parser.NetexParser;
import org.rutebanken.netex.model.DayType;
import org.rutebanken.netex.model.DayTypeAssignment;
import org.rutebanken.netex.model.DayTypeAssignmentsInFrame_RelStructure;
import org.rutebanken.netex.model.DayTypeAssignments_RelStructure;
import org.rutebanken.netex.model.DayTypeRefStructure;
import org.rutebanken.netex.model.DayTypesInFrame_RelStructure;
import org.rutebanken.netex.model.DayTypes_RelStructure;
import org.rutebanken.netex.model.OperatingDay;
import org.rutebanken.netex.model.OperatingDaysInFrame_RelStructure;
import org.rutebanken.netex.model.OperatingDays_RelStructure;
import org.rutebanken.netex.model.OperatingPeriod;
import org.rutebanken.netex.model.OperatingPeriod_VersionStructure;
import org.rutebanken.netex.model.OperatingPeriodsInFrame_RelStructure;
import org.rutebanken.netex.model.OperatingPeriods_RelStructure;
import org.rutebanken.netex.model.ServiceCalendar;
import org.rutebanken.netex.model.ServiceCalendarFrame_VersionFrameStructure;
import org.rutebanken.netex.model.VersionFrame_VersionStructure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceCalendarFrameParser
extends NetexParser<ServiceCalendarFrame_VersionFrameStructure> {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceCalendarFrameParser.class);
    private final Collection<DayType> dayTypes = new ArrayList<DayType>();
    private final Collection<OperatingPeriod> operatingPeriods = new ArrayList<OperatingPeriod>();
    private final Collection<OperatingDay> operatingDays = new ArrayList<OperatingDay>();
    private final Multimap<String, DayTypeAssignment> dayTypeAssignmentByDayTypeId = ArrayListMultimap.create();

    ServiceCalendarFrameParser() {
    }

    @Override
    void parse(ServiceCalendarFrame_VersionFrameStructure frame) {
        this.parseServiceCalendar(frame.getServiceCalendar());
        this.parseDayTypes(frame.getDayTypes());
        this.parseOperatingPeriods(frame.getOperatingPeriods());
        this.parseOperatingDays(frame.getOperatingDays());
        this.parseDayTypeAssignments(frame.getDayTypeAssignments());
        ServiceCalendarFrameParser.informOnElementIntentionallySkipped(LOG, frame.getTimebands());
        ServiceCalendarFrameParser.informOnElementIntentionallySkipped(LOG, frame.getGroupOfTimebands());
        ServiceCalendarFrameParser.verifyCommonUnusedPropertiesIsNotSet(LOG, (VersionFrame_VersionStructure)frame);
    }

    @Override
    void setResultOnIndex(NetexEntitiesIndex netexIndex) {
        netexIndex.getDayTypeIndex().putAll(this.dayTypes);
        netexIndex.getOperatingPeriodIndex().putAll(this.operatingPeriods);
        netexIndex.getOperatingDayIndex().putAll(this.operatingDays);
        netexIndex.getDayTypeAssignmentsByDayTypeIdIndex().putAll(this.dayTypeAssignmentByDayTypeId);
    }

    private void parseServiceCalendar(ServiceCalendar serviceCalendar) {
        if (serviceCalendar == null) {
            return;
        }
        this.parseDayTypes(serviceCalendar.getDayTypes());
        this.parseOperatingDays(serviceCalendar.getOperatingDays());
        this.parseOperatingPeriods(serviceCalendar.getOperatingPeriods());
        this.parseDayTypeAssignments(serviceCalendar.getDayTypeAssignments());
    }

    private void parseDayTypes(DayTypesInFrame_RelStructure element) {
        if (element == null) {
            return;
        }
        for (JAXBElement dt : element.getDayType_()) {
            this.parseDayType(dt);
        }
    }

    private void parseDayTypes(DayTypes_RelStructure dayTypes) {
        if (dayTypes == null) {
            return;
        }
        for (JAXBElement dt : dayTypes.getDayTypeRefOrDayType_()) {
            this.parseDayType(dt);
        }
    }

    private void parseDayType(JAXBElement<?> dt) {
        if (dt.getValue() instanceof DayType) {
            this.dayTypes.add((DayType)dt.getValue());
        }
    }

    private void parseOperatingPeriods(OperatingPeriodsInFrame_RelStructure element) {
        if (element == null) {
            return;
        }
        for (OperatingPeriod_VersionStructure p : element.getOperatingPeriodOrUicOperatingPeriod()) {
            this.operatingPeriods.add((OperatingPeriod)p);
        }
    }

    private void parseOperatingPeriods(OperatingPeriods_RelStructure operatingPeriodsRelStructure) {
        if (operatingPeriodsRelStructure == null) {
            return;
        }
        for (JAXBElement object : operatingPeriodsRelStructure.getOperatingPeriodRefOrOperatingPeriodOrUicOperatingPeriod()) {
            Object value = object.getValue();
            if (!(value instanceof OperatingPeriod)) continue;
            this.operatingPeriods.add((OperatingPeriod)object.getValue());
        }
    }

    private void parseOperatingDays(OperatingDaysInFrame_RelStructure element) {
        if (element == null) {
            return;
        }
        this.operatingDays.addAll(element.getOperatingDay());
    }

    private void parseOperatingDays(OperatingDays_RelStructure operatingDaysRelStructure) {
        if (operatingDaysRelStructure == null) {
            return;
        }
        for (Object object : operatingDaysRelStructure.getOperatingDayRefOrOperatingDay()) {
            this.operatingDays.add((OperatingDay)object);
        }
    }

    private void parseDayTypeAssignments(DayTypeAssignments_RelStructure element) {
        if (element == null) {
            return;
        }
        this.parseDayTypeAssignments(element.getDayTypeAssignment());
    }

    private void parseDayTypeAssignments(DayTypeAssignmentsInFrame_RelStructure element) {
        if (element == null) {
            return;
        }
        this.parseDayTypeAssignments(element.getDayTypeAssignment());
    }

    private void parseDayTypeAssignments(List<DayTypeAssignment> elements) {
        for (DayTypeAssignment it : elements) {
            String ref = ((DayTypeRefStructure)it.getDayTypeRef().getValue()).getRef();
            this.dayTypeAssignmentByDayTypeId.put((Object)ref, (Object)it);
        }
    }
}

