/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.loader.parser;

import jakarta.xml.bind.JAXBElement;
import java.util.List;
import org.entur.netex.index.api.NetexEntitiesIndex;
import org.entur.netex.loader.parser.FareFrameParser;
import org.entur.netex.loader.parser.NetexParser;
import org.entur.netex.loader.parser.ResourceFrameParser;
import org.entur.netex.loader.parser.ServiceCalendarFrameParser;
import org.entur.netex.loader.parser.ServiceFrameParser;
import org.entur.netex.loader.parser.SiteFrameParser;
import org.entur.netex.loader.parser.TimeTableFrameParser;
import org.entur.netex.loader.parser.VehicleScheduleFrameParser;
import org.rutebanken.netex.model.Common_VersionFrameStructure;
import org.rutebanken.netex.model.CompositeFrame;
import org.rutebanken.netex.model.FareFrame;
import org.rutebanken.netex.model.GeneralFrame;
import org.rutebanken.netex.model.InfrastructureFrame;
import org.rutebanken.netex.model.PublicationDeliveryStructure;
import org.rutebanken.netex.model.ResourceFrame;
import org.rutebanken.netex.model.ServiceCalendarFrame;
import org.rutebanken.netex.model.ServiceFrame;
import org.rutebanken.netex.model.SiteFrame;
import org.rutebanken.netex.model.TimetableFrame;
import org.rutebanken.netex.model.VehicleScheduleFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetexDocumentParser {
    private static final Logger LOG = LoggerFactory.getLogger(NetexDocumentParser.class);
    private final NetexEntitiesIndex netexIndex;

    private NetexDocumentParser(NetexEntitiesIndex netexIndex) {
        this.netexIndex = netexIndex;
    }

    public static void parseAndPopulateIndex(NetexEntitiesIndex index, PublicationDeliveryStructure doc) {
        new NetexDocumentParser(index).parse(doc);
    }

    private void parse(PublicationDeliveryStructure doc) {
        this.netexIndex.setPublicationTimestamp(doc.getPublicationTimestamp());
        this.parseFrameList(doc.getDataObjects().getCompositeFrameOrCommonFrame());
    }

    private void parseFrameList(List<JAXBElement<? extends Common_VersionFrameStructure>> frames) {
        for (JAXBElement<? extends Common_VersionFrameStructure> frame : frames) {
            this.parseCommonFrame((Common_VersionFrameStructure)frame.getValue());
        }
    }

    private void parseCommonFrame(Common_VersionFrameStructure value) {
        if (value instanceof ResourceFrame) {
            ResourceFrame resourceFrame = (ResourceFrame)value;
            this.netexIndex.getResourceFrames().add(resourceFrame);
            this.parse((ResourceFrame)value, new ResourceFrameParser());
        } else if (value instanceof ServiceCalendarFrame) {
            ServiceCalendarFrame serviceCalendarFrame = (ServiceCalendarFrame)value;
            this.netexIndex.getServiceCalendarFrames().add(serviceCalendarFrame);
            this.parse((ServiceCalendarFrame)value, new ServiceCalendarFrameParser());
        } else if (value instanceof VehicleScheduleFrame) {
            VehicleScheduleFrame vehicleScheduleFrame = (VehicleScheduleFrame)value;
            this.netexIndex.getVehicleScheduleFrames().add(vehicleScheduleFrame);
            this.parse((VehicleScheduleFrame)value, new VehicleScheduleFrameParser());
        } else if (value instanceof TimetableFrame) {
            TimetableFrame timetableFrame = (TimetableFrame)value;
            this.netexIndex.getTimetableFrames().add(timetableFrame);
            this.parse((TimetableFrame)value, new TimeTableFrameParser());
        } else if (value instanceof ServiceFrame) {
            ServiceFrame serviceFrame = (ServiceFrame)value;
            this.netexIndex.getServiceFrames().add(serviceFrame);
            this.parse((ServiceFrame)value, new ServiceFrameParser(this.netexIndex.getFlexibleStopPlaceIndex()));
        } else if (value instanceof SiteFrame) {
            SiteFrame siteFrame = (SiteFrame)value;
            this.netexIndex.getSiteFrames().add(siteFrame);
            this.parse((SiteFrame)value, new SiteFrameParser());
        } else if (value instanceof FareFrame) {
            FareFrame fareFrame = (FareFrame)value;
            this.parse(fareFrame, new FareFrameParser());
        } else if (value instanceof CompositeFrame) {
            CompositeFrame compositeFrame = (CompositeFrame)value;
            this.netexIndex.getCompositeFrames().add(compositeFrame);
            this.parseCompositeFrame(compositeFrame);
        } else if (value instanceof GeneralFrame || value instanceof InfrastructureFrame) {
            NetexParser.informOnElementIntentionallySkipped(LOG, value);
        } else {
            NetexParser.informOnElementIntentionallySkipped(LOG, value);
        }
    }

    private void parseCompositeFrame(CompositeFrame frame) {
        if (frame.getFrames() == null) {
            LOG.debug("Composite frame {} has no frames, skipping", (Object)frame.getId());
            return;
        }
        List frames = frame.getFrames().getCommonFrame();
        for (JAXBElement it : frames) {
            this.parseCommonFrame((Common_VersionFrameStructure)it.getValue());
        }
    }

    private <T> void parse(T node, NetexParser<T> parser) {
        parser.parse(node);
        parser.setResultOnIndex(this.netexIndex);
    }
}

