/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex;

import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLStreamReader;
import org.entur.netex.XmlStreamReaderFactory;
import org.entur.netex.index.api.NetexEntitiesIndex;
import org.entur.netex.index.impl.NetexEntitiesIndexImpl;
import org.entur.netex.loader.NetexXmlParser;
import org.entur.netex.loader.parser.NetexDocumentParser;
import org.rutebanken.netex.model.PublicationDeliveryStructure;

public class NetexParser {
    private final NetexXmlParser xmlParser = new NetexXmlParser();
    private final XmlStreamReaderFactory xmlStreamReaderFactory;

    public NetexParser() {
        this.xmlStreamReaderFactory = null;
    }

    public NetexParser(XmlStreamReaderFactory xmlStreamReaderFactory) {
        this.xmlStreamReaderFactory = xmlStreamReaderFactory;
    }

    public NetexEntitiesIndex parse(String pathToZip) throws IOException {
        NetexEntitiesIndexImpl index = new NetexEntitiesIndexImpl();
        return this.parse(pathToZip, (NetexEntitiesIndex)index);
    }

    public NetexEntitiesIndex parse(String pathToZip, NetexEntitiesIndex index) throws IOException {
        try (ZipFile zipFile = new ZipFile(pathToZip);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                InputStream stream = zipFile.getInputStream(entry);
                this.load(index, stream);
            }
            NetexEntitiesIndex netexEntitiesIndex = index;
            return netexEntitiesIndex;
        }
    }

    public NetexEntitiesIndex parse(InputStream inputStream) {
        NetexEntitiesIndexImpl index = new NetexEntitiesIndexImpl();
        this.load(index, inputStream);
        return index;
    }

    public NetexEntitiesIndex parse(InputStream inputStream, NetexEntitiesIndex index) {
        this.load(index, inputStream);
        return index;
    }

    private void load(NetexEntitiesIndex index, InputStream inputStream) {
        try {
            PublicationDeliveryStructure doc;
            if (this.xmlStreamReaderFactory != null) {
                XMLStreamReader xmlReader = this.xmlStreamReaderFactory.createXmlStreamReader(inputStream);
                doc = this.xmlParser.parseXmlDoc(xmlReader);
            } else {
                doc = this.xmlParser.parseXmlDoc(inputStream);
            }
            NetexDocumentParser.parseAndPopulateIndex(index, doc);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

