/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex;

import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.entur.netex.index.api.NetexEntitiesIndex;
import org.entur.netex.index.impl.NetexEntitiesIndexImpl;
import org.entur.netex.loader.NetexXmlParser;
import org.entur.netex.loader.parser.NetexDocumentParser;
import org.rutebanken.netex.model.PublicationDeliveryStructure;

public class NetexParser {
    private final NetexXmlParser xmlParser = new NetexXmlParser();

    public NetexEntitiesIndex parse(String pathToZip) throws IOException {
        NetexEntitiesIndexImpl index = new NetexEntitiesIndexImpl();
        return this.parse(pathToZip, (NetexEntitiesIndex)index);
    }

    public NetexEntitiesIndex parse(String pathToZip, NetexEntitiesIndex index) throws IOException {
        try (ZipFile zipFile = new ZipFile(pathToZip);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                InputStream stream = zipFile.getInputStream(entry);
                this.load(index, stream);
            }
            NetexEntitiesIndex netexEntitiesIndex = index;
            return netexEntitiesIndex;
        }
    }

    public NetexEntitiesIndex parse(InputStream inputStream) {
        NetexEntitiesIndexImpl index = new NetexEntitiesIndexImpl();
        this.load(index, inputStream);
        return index;
    }

    public NetexEntitiesIndex parse(InputStream inputStream, NetexEntitiesIndex index) {
        this.load(index, inputStream);
        return index;
    }

    private void load(NetexEntitiesIndex index, InputStream inputStream) {
        try {
            PublicationDeliveryStructure doc = this.xmlParser.parseXmlDoc(inputStream);
            NetexDocumentParser.parseAndPopulateIndex(index, doc);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

