/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.loader.parser;

import jakarta.xml.bind.JAXBElement;
import java.util.ArrayList;
import java.util.Collection;
import org.entur.netex.index.api.NetexEntitiesIndex;
import org.entur.netex.loader.parser.NetexParser;
import org.rutebanken.netex.model.Authority;
import org.rutebanken.netex.model.Branding;
import org.rutebanken.netex.model.Operator;
import org.rutebanken.netex.model.Organisation_VersionStructure;
import org.rutebanken.netex.model.OrganisationsInFrame_RelStructure;
import org.rutebanken.netex.model.ResourceFrame_VersionFrameStructure;
import org.rutebanken.netex.model.TypesOfValueInFrame_RelStructure;
import org.rutebanken.netex.model.VersionFrame_VersionStructure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResourceFrameParser
extends NetexParser<ResourceFrame_VersionFrameStructure> {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceFrameParser.class);
    private final Collection<Authority> authorities = new ArrayList<Authority>();
    private final Collection<Operator> operators = new ArrayList<Operator>();
    private final Collection<Branding> brandings = new ArrayList<Branding>();

    ResourceFrameParser() {
    }

    @Override
    void parse(ResourceFrame_VersionFrameStructure frame) {
        this.parseOrganisations(frame.getOrganisations());
        this.parseTypeOfValues(frame.getTypesOfValue());
        ResourceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getBlacklists());
        ResourceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getControlCentres());
        ResourceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getDataSources());
        ResourceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getEquipments());
        ResourceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getGroupsOfEntities());
        ResourceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getGroupsOfOperators());
        ResourceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getOperationalContexts());
        ResourceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getResponsibilitySets());
        ResourceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getSchematicMaps());
        ResourceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getVehicles());
        ResourceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getVehicleEquipmentProfiles());
        ResourceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getVehicleModels());
        ResourceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getVehicleTypes());
        ResourceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getWhitelists());
        ResourceFrameParser.informOnElementIntentionallySkipped(LOG, frame.getZones());
        ResourceFrameParser.verifyCommonUnusedPropertiesIsNotSet(LOG, (VersionFrame_VersionStructure)frame);
    }

    @Override
    void setResultOnIndex(NetexEntitiesIndex netexIndex) {
        netexIndex.getAuthorityIndex().putAll(this.authorities);
        netexIndex.getOperatorIndex().putAll(this.operators);
        netexIndex.getBrandingIndex().putAll(this.brandings);
    }

    private void parseOrganisations(OrganisationsInFrame_RelStructure elements) {
        if (elements != null) {
            for (JAXBElement e : elements.getOrganisation_()) {
                this.parseOrganisation((Organisation_VersionStructure)e.getValue());
            }
        }
    }

    private void parseOrganisation(Organisation_VersionStructure element) {
        if (element instanceof Authority) {
            Authority authority = (Authority)element;
            this.authorities.add(authority);
        } else if (element instanceof Operator) {
            Operator operator = (Operator)element;
            this.operators.add(operator);
        } else {
            ResourceFrameParser.informOnElementIntentionallySkipped(LOG, element);
        }
    }

    private void parseTypeOfValues(TypesOfValueInFrame_RelStructure typesOfValue) {
        if (typesOfValue != null) {
            for (JAXBElement e : typesOfValue.getValueSetOrTypeOfValue()) {
                if (e.getValue() instanceof Branding) {
                    this.brandings.add((Branding)e.getValue());
                    continue;
                }
                ResourceFrameParser.informOnElementIntentionallySkipped(LOG, e);
            }
        }
    }
}

