/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.loader.parser;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import org.entur.netex.index.api.NetexEntitiesIndex;
import org.entur.netex.loader.parser.NetexParser;
import org.entur.netex.loader.parser.NoticeParser;
import org.rutebanken.netex.model.DatedServiceJourney;
import org.rutebanken.netex.model.Interchange_VersionStructure;
import org.rutebanken.netex.model.JourneyInterchangesInFrame_RelStructure;
import org.rutebanken.netex.model.JourneyRefStructure;
import org.rutebanken.netex.model.Journey_VersionStructure;
import org.rutebanken.netex.model.JourneysInFrame_RelStructure;
import org.rutebanken.netex.model.ServiceJourney;
import org.rutebanken.netex.model.ServiceJourneyInterchange;
import org.rutebanken.netex.model.ServiceJourneyRefStructure;
import org.rutebanken.netex.model.Timetable_VersionFrameStructure;
import org.rutebanken.netex.model.VersionFrame_VersionStructure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TimeTableFrameParser
extends NetexParser<Timetable_VersionFrameStructure> {
    private static final Logger LOG = LoggerFactory.getLogger(TimeTableFrameParser.class);
    private final List<ServiceJourney> serviceJourneys = new ArrayList<ServiceJourney>();
    private final List<DatedServiceJourney> datedServiceJourneys = new ArrayList<DatedServiceJourney>();
    private final Multimap<String, DatedServiceJourney> datedServiceJourneyByServiceJourneyId = ArrayListMultimap.create();
    private final List<ServiceJourneyInterchange> serviceJourneyInterchanges = new ArrayList<ServiceJourneyInterchange>();
    private final Multimap<String, ServiceJourneyInterchange> serviceJourneyInterchangesByServiceJourneyId = ArrayListMultimap.create();
    private final NoticeParser noticeParser = new NoticeParser();

    TimeTableFrameParser() {
    }

    @Override
    void parse(Timetable_VersionFrameStructure frame) {
        this.parseJourneys(frame.getVehicleJourneys());
        this.parseInterchanges(frame.getJourneyInterchanges());
        this.noticeParser.parseNotices(frame.getNotices());
        this.noticeParser.parseNoticeAssignments(frame.getNoticeAssignments());
        TimeTableFrameParser.informOnElementIntentionallySkipped(LOG, frame.getNetworkView());
        TimeTableFrameParser.informOnElementIntentionallySkipped(LOG, frame.getLineView());
        TimeTableFrameParser.informOnElementIntentionallySkipped(LOG, frame.getOperatorView());
        TimeTableFrameParser.informOnElementIntentionallySkipped(LOG, frame.getAccessibilityAssessment());
        TimeTableFrameParser.informOnElementIntentionallySkipped(LOG, frame.getBookingTimes());
        TimeTableFrameParser.informOnElementIntentionallySkipped(LOG, frame.getVehicleTypeRef());
        TimeTableFrameParser.informOnElementIntentionallySkipped(LOG, frame.getCoupledJourneys());
        TimeTableFrameParser.informOnElementIntentionallySkipped(LOG, frame.getDefaultInterchanges());
        TimeTableFrameParser.informOnElementIntentionallySkipped(LOG, frame.getFlexibleServiceProperties());
        TimeTableFrameParser.informOnElementIntentionallySkipped(LOG, frame.getFrequencyGroups());
        TimeTableFrameParser.informOnElementIntentionallySkipped(LOG, frame.getGroupsOfServices());
        TimeTableFrameParser.informOnElementIntentionallySkipped(LOG, frame.getInterchangeRules());
        TimeTableFrameParser.informOnElementIntentionallySkipped(LOG, frame.getJourneyAccountingRef());
        TimeTableFrameParser.informOnElementIntentionallySkipped(LOG, frame.getJourneyAccountings());
        TimeTableFrameParser.informOnElementIntentionallySkipped(LOG, frame.getJourneyMeetings());
        TimeTableFrameParser.informOnElementIntentionallySkipped(LOG, frame.getJourneyPartCouples());
        TimeTableFrameParser.informOnElementIntentionallySkipped(LOG, frame.getServiceCalendarFrameRef());
        TimeTableFrameParser.informOnElementIntentionallySkipped(LOG, frame.getServiceFacilitySets());
        TimeTableFrameParser.informOnElementIntentionallySkipped(LOG, frame.getTimeDemandTypes());
        TimeTableFrameParser.informOnElementIntentionallySkipped(LOG, frame.getTimeDemandTypeAssignments());
        TimeTableFrameParser.informOnElementIntentionallySkipped(LOG, frame.getTimingLinkGroups());
        TimeTableFrameParser.informOnElementIntentionallySkipped(LOG, frame.getTrainNumbers());
        TimeTableFrameParser.informOnElementIntentionallySkipped(LOG, frame.getTypesOfService());
        TimeTableFrameParser.informOnElementIntentionallySkipped(LOG, frame.getVehicleTypes());
        TimeTableFrameParser.verifyCommonUnusedPropertiesIsNotSet(LOG, (VersionFrame_VersionStructure)frame);
    }

    @Override
    void setResultOnIndex(NetexEntitiesIndex netexIndex) {
        netexIndex.getServiceJourneyIndex().putAll(this.serviceJourneys);
        netexIndex.getDatedServiceJourneyIndex().putAll(this.datedServiceJourneys);
        netexIndex.getDatedServiceJourneyByServiceJourneyRefIndex().putAll(this.datedServiceJourneyByServiceJourneyId);
        netexIndex.getServiceJourneyInterchangeIndex().putAll(this.serviceJourneyInterchanges);
        netexIndex.getServiceJourneyInterchangeByServiceJourneyRefIndex().putAll(this.serviceJourneyInterchangesByServiceJourneyId);
        this.noticeParser.setResultOnIndex(netexIndex);
    }

    private void parseJourneys(JourneysInFrame_RelStructure element) {
        for (Journey_VersionStructure it : element.getVehicleJourneyOrDatedVehicleJourneyOrNormalDatedVehicleJourney()) {
            if (it instanceof ServiceJourney) {
                this.serviceJourneys.add((ServiceJourney)it);
                continue;
            }
            if (it instanceof DatedServiceJourney) {
                DatedServiceJourney datedServiceJourney = (DatedServiceJourney)it;
                this.datedServiceJourneys.add(datedServiceJourney);
                datedServiceJourney.getJourneyRef().stream().filter(journeyRef -> journeyRef.getValue() instanceof ServiceJourneyRefStructure).map(journeyRef -> ((JourneyRefStructure)journeyRef.getValue()).getRef()).forEach(serviceJourneyId -> this.datedServiceJourneyByServiceJourneyId.put(serviceJourneyId, (Object)datedServiceJourney));
                continue;
            }
            TimeTableFrameParser.informOnElementIntentionallySkipped(LOG, it);
        }
    }

    private void parseInterchanges(JourneyInterchangesInFrame_RelStructure journeyInterchangesElement) {
        if (journeyInterchangesElement == null) {
            return;
        }
        for (Interchange_VersionStructure it : journeyInterchangesElement.getServiceJourneyPatternInterchangeOrServiceJourneyInterchange()) {
            if (it instanceof ServiceJourneyInterchange) {
                ServiceJourneyInterchange serviceJourneyInterchange = (ServiceJourneyInterchange)it;
                this.serviceJourneyInterchanges.add(serviceJourneyInterchange);
                String fromRef = serviceJourneyInterchange.getFromJourneyRef().getRef();
                this.serviceJourneyInterchangesByServiceJourneyId.put((Object)fromRef, (Object)serviceJourneyInterchange);
                String toRef = serviceJourneyInterchange.getToJourneyRef().getRef();
                this.serviceJourneyInterchangesByServiceJourneyId.put((Object)toRef, (Object)serviceJourneyInterchange);
                continue;
            }
            TimeTableFrameParser.informOnElementIntentionallySkipped(LOG, it);
        }
    }
}

