/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.loader.parser;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import org.entur.netex.index.api.NetexEntitiesIndex;
import org.entur.netex.loader.parser.NetexParser;
import org.entur.netex.support.NetexVersionHelper;
import org.rutebanken.netex.model.FlexibleStopPlace;
import org.rutebanken.netex.model.GroupOfStopPlaces;
import org.rutebanken.netex.model.GroupOfTariffZones;
import org.rutebanken.netex.model.Parking;
import org.rutebanken.netex.model.Quay;
import org.rutebanken.netex.model.Quays_RelStructure;
import org.rutebanken.netex.model.Site_VersionFrameStructure;
import org.rutebanken.netex.model.StopPlace;
import org.rutebanken.netex.model.TariffZone;
import org.rutebanken.netex.model.TopographicPlace;
import org.rutebanken.netex.model.VersionFrame_VersionStructure;
import org.rutebanken.netex.model.Zone_VersionStructure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SiteFrameParser
extends NetexParser<Site_VersionFrameStructure> {
    private static final Logger LOG = LoggerFactory.getLogger(NetexParser.class);
    private final Collection<FlexibleStopPlace> flexibleStopPlaces = new ArrayList<FlexibleStopPlace>();
    private final Collection<GroupOfStopPlaces> groupsOfStopPlaces = new ArrayList<GroupOfStopPlaces>();
    private final Collection<StopPlace> stopPlaces = new ArrayList<StopPlace>();
    private final Collection<TariffZone> tariffZones = new ArrayList<TariffZone>();
    private final Collection<GroupOfTariffZones> groupsOfTariffZones = new ArrayList<GroupOfTariffZones>();
    private final Collection<TopographicPlace> topographicPlaces = new ArrayList<TopographicPlace>();
    private final Collection<Parking> parkings = new ArrayList<Parking>();
    private final Multimap<String, Quay> quays = ArrayListMultimap.create();
    private final Map<String, String> stopPlaceIdByQuayId = new HashMap<String, String>();
    private final Multimap<String, Parking> parkingsByStopPlaceId = ArrayListMultimap.create();

    SiteFrameParser() {
    }

    @Override
    public void parse(Site_VersionFrameStructure frame) {
        if (frame.getStopPlaces() != null) {
            this.parseStopPlaces(frame.getStopPlaces().getStopPlace());
        }
        if (frame.getGroupsOfStopPlaces() != null) {
            this.parseGroupsOfStopPlaces(frame.getGroupsOfStopPlaces().getGroupOfStopPlaces());
        }
        if (frame.getFlexibleStopPlaces() != null) {
            this.parseFlexibleStopPlaces(frame.getFlexibleStopPlaces().getFlexibleStopPlace());
        }
        if (frame.getTariffZones() != null) {
            this.parseTariffZones(frame.getTariffZones().getTariffZone());
        }
        if (frame.getTopographicPlaces() != null) {
            this.parseTopographicPlaces(frame.getTopographicPlaces().getTopographicPlace());
        }
        if (frame.getParkings() != null) {
            this.parseParkings(frame.getParkings().getParking());
        }
        if (frame.getGroupsOfTariffZones() != null) {
            this.parseGroupsOfTariffZones(frame.getGroupsOfTariffZones().getGroupOfTariffZones());
        }
        SiteFrameParser.informOnElementIntentionallySkipped(LOG, frame.getAccesses());
        SiteFrameParser.informOnElementIntentionallySkipped(LOG, frame.getAddresses());
        SiteFrameParser.informOnElementIntentionallySkipped(LOG, frame.getCountries());
        SiteFrameParser.informOnElementIntentionallySkipped(LOG, frame.getCheckConstraints());
        SiteFrameParser.informOnElementIntentionallySkipped(LOG, frame.getCheckConstraintDelays());
        SiteFrameParser.informOnElementIntentionallySkipped(LOG, frame.getCheckConstraintThroughputs());
        SiteFrameParser.informOnElementIntentionallySkipped(LOG, frame.getNavigationPaths());
        SiteFrameParser.informOnElementIntentionallySkipped(LOG, frame.getPathJunctions());
        SiteFrameParser.informOnElementIntentionallySkipped(LOG, frame.getPathLinks());
        SiteFrameParser.informOnElementIntentionallySkipped(LOG, frame.getPointsOfInterest());
        SiteFrameParser.informOnElementIntentionallySkipped(LOG, frame.getPointOfInterestClassifications());
        SiteFrameParser.informOnElementIntentionallySkipped(LOG, frame.getPointOfInterestClassificationHierarchies());
        SiteFrameParser.informOnElementIntentionallySkipped(LOG, frame.getSiteFacilitySets());
        SiteFrameParser.verifyCommonUnusedPropertiesIsNotSet(LOG, (VersionFrame_VersionStructure)frame);
    }

    @Override
    void setResultOnIndex(NetexEntitiesIndex netexIndex) {
        netexIndex.getFlexibleStopPlaceIndex().putAll(this.flexibleStopPlaces);
        netexIndex.getGroupOfStopPlacesIndex().putAll(this.groupsOfStopPlaces);
        netexIndex.getStopPlaceIndex().putAll(this.stopPlaces);
        netexIndex.getTariffZoneIndex().putAll(this.tariffZones);
        netexIndex.getTopographicPlaceIndex().putAll(this.topographicPlaces);
        netexIndex.getParkingIndex().putAll(this.parkings);
        netexIndex.getQuayIndex().putAll(this.quays.values());
        netexIndex.getStopPlaceIdByQuayIdIndex().putAll(this.stopPlaceIdByQuayId);
        netexIndex.getParkingsByParentSiteRefIndex().putAll(this.parkingsByStopPlaceId);
        netexIndex.getGroupOfTariffZonesIndex().putAll(this.groupsOfTariffZones);
    }

    private void parseFlexibleStopPlaces(Collection<FlexibleStopPlace> flexibleStopPlacesList) {
        this.flexibleStopPlaces.addAll(flexibleStopPlacesList);
    }

    private void parseGroupsOfStopPlaces(Collection<GroupOfStopPlaces> groupsOfStopPlacesList) {
        this.groupsOfStopPlaces.addAll(groupsOfStopPlacesList);
    }

    private void parseStopPlaces(Collection<StopPlace> stopPlaceList) {
        for (StopPlace stopPlace : stopPlaceList) {
            this.stopPlaces.add(stopPlace);
            if (this.isMultiModalStopPlace(stopPlace)) continue;
            this.parseQuays(stopPlace.getQuays(), stopPlace.getId());
        }
    }

    private void parseTariffZones(List<JAXBElement<? extends Zone_VersionStructure>> tariffZoneList) {
        for (JAXBElement<? extends Zone_VersionStructure> tariffZone : tariffZoneList) {
            if (!(tariffZone.getValue() instanceof TariffZone)) continue;
            this.tariffZones.add((TariffZone)tariffZone.getValue());
        }
    }

    private void parseTopographicPlaces(Collection<TopographicPlace> topographicPlaceList) {
        this.topographicPlaces.addAll(topographicPlaceList);
    }

    private void parseParkings(Collection<Parking> parkingList) {
        for (Parking parking : parkingList) {
            this.parkings.add(parking);
            this.parkingsByStopPlaceId.put((Object)parking.getParentSiteRef().getRef(), (Object)parking);
        }
    }

    private void parseQuays(Quays_RelStructure quayRefOrQuay, String stopPlaceId) {
        if (quayRefOrQuay == null) {
            return;
        }
        for (Object quayObject : quayRefOrQuay.getQuayRefOrQuay()) {
            Quay latestVersion;
            if (!(quayObject instanceof Quay)) continue;
            Quay quay = (Quay)quayObject;
            String quayId = quay.getId();
            this.quays.put((Object)quayId, (Object)quay);
            if (!this.stopPlaceIdByQuayId.containsKey(quayId)) {
                this.stopPlaceIdByQuayId.put(quayId, stopPlaceId);
                continue;
            }
            if (this.stopPlaceIdByQuayId.get(quayId).equals(stopPlaceId) || !quayObject.equals(latestVersion = (Quay)NetexVersionHelper.latestVersionedElementIn(this.quays.get((Object)quayId)))) continue;
            this.stopPlaceIdByQuayId.put(quayId, stopPlaceId);
        }
    }

    private boolean isMultiModalStopPlace(StopPlace stopPlace) {
        return stopPlace.getKeyList() != null && stopPlace.getKeyList().getKeyValue().stream().anyMatch(keyValueStructure -> keyValueStructure.getKey().equals("IS_PARENT_STOP_PLACE") && keyValueStructure.getValue().equals("true"));
    }

    private void parseGroupsOfTariffZones(List<GroupOfTariffZones> groupOfTariffZones) {
        this.groupsOfTariffZones.addAll(groupOfTariffZones);
    }
}

