/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.loader.parser;

import java.util.List;
import javax.xml.bind.JAXBElement;
import org.entur.netex.index.api.NetexEntitiesIndex;
import org.entur.netex.loader.parser.FareFrameParser;
import org.entur.netex.loader.parser.NetexParser;
import org.entur.netex.loader.parser.ResourceFrameParser;
import org.entur.netex.loader.parser.ServiceCalendarFrameParser;
import org.entur.netex.loader.parser.ServiceFrameParser;
import org.entur.netex.loader.parser.SiteFrameParser;
import org.entur.netex.loader.parser.TimeTableFrameParser;
import org.entur.netex.loader.parser.VehicleScheduleFrameParser;
import org.rutebanken.netex.model.Common_VersionFrameStructure;
import org.rutebanken.netex.model.CompositeFrame;
import org.rutebanken.netex.model.FareFrame;
import org.rutebanken.netex.model.GeneralFrame;
import org.rutebanken.netex.model.InfrastructureFrame;
import org.rutebanken.netex.model.PublicationDeliveryStructure;
import org.rutebanken.netex.model.ResourceFrame;
import org.rutebanken.netex.model.ServiceCalendarFrame;
import org.rutebanken.netex.model.ServiceFrame;
import org.rutebanken.netex.model.SiteFrame;
import org.rutebanken.netex.model.TimetableFrame;
import org.rutebanken.netex.model.VehicleScheduleFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetexDocumentParser {
    private static final Logger LOG = LoggerFactory.getLogger(NetexDocumentParser.class);
    private final NetexEntitiesIndex netexIndex;

    private NetexDocumentParser(NetexEntitiesIndex netexIndex) {
        this.netexIndex = netexIndex;
    }

    public static void parseAndPopulateIndex(NetexEntitiesIndex index, PublicationDeliveryStructure doc) {
        new NetexDocumentParser(index).parse(doc);
    }

    private void parse(PublicationDeliveryStructure doc) {
        this.netexIndex.setPublicationTimestamp(doc.getPublicationTimestamp());
        this.parseFrameList(doc.getDataObjects().getCompositeFrameOrCommonFrame());
    }

    private void parseFrameList(List<JAXBElement<? extends Common_VersionFrameStructure>> frames) {
        for (JAXBElement<? extends Common_VersionFrameStructure> frame : frames) {
            this.parseCommonFrame((Common_VersionFrameStructure)frame.getValue());
        }
    }

    private void parseCommonFrame(Common_VersionFrameStructure value) {
        if (value instanceof ResourceFrame) {
            this.netexIndex.getResourceFrames().add((ResourceFrame)value);
            this.parse((ResourceFrame)value, new ResourceFrameParser());
        } else if (value instanceof ServiceCalendarFrame) {
            this.netexIndex.getServiceCalendarFrames().add((ServiceCalendarFrame)value);
            this.parse((ServiceCalendarFrame)value, new ServiceCalendarFrameParser());
        } else if (value instanceof VehicleScheduleFrame) {
            this.netexIndex.getVehicleScheduleFrames().add((VehicleScheduleFrame)value);
            this.parse((VehicleScheduleFrame)value, new VehicleScheduleFrameParser());
        } else if (value instanceof TimetableFrame) {
            this.netexIndex.getTimetableFrames().add((TimetableFrame)value);
            this.parse((TimetableFrame)value, new TimeTableFrameParser());
        } else if (value instanceof ServiceFrame) {
            this.netexIndex.getServiceFrames().add((ServiceFrame)value);
            this.parse((ServiceFrame)value, new ServiceFrameParser(this.netexIndex.getFlexibleStopPlaceIndex()));
        } else if (value instanceof SiteFrame) {
            this.netexIndex.getSiteFrames().add((SiteFrame)value);
            this.parse((SiteFrame)value, new SiteFrameParser());
        } else if (value instanceof FareFrame) {
            this.parse((FareFrame)value, new FareFrameParser());
        } else if (value instanceof CompositeFrame) {
            this.netexIndex.getCompositeFrames().add((CompositeFrame)value);
            this.parseCompositeFrame((CompositeFrame)value);
        } else if (value instanceof GeneralFrame || value instanceof InfrastructureFrame) {
            NetexParser.informOnElementIntentionallySkipped(LOG, value);
        } else {
            NetexParser.informOnElementIntentionallySkipped(LOG, value);
        }
    }

    private void parseCompositeFrame(CompositeFrame frame) {
        List frames = frame.getFrames().getCommonFrame();
        for (JAXBElement it : frames) {
            this.parseCommonFrame((Common_VersionFrameStructure)it.getValue());
        }
    }

    private <T> void parse(T node, NetexParser<T> parser) {
        parser.parse(node);
        parser.setResultOnIndex(this.netexIndex);
    }
}

