/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.index.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.entur.netex.index.api.VersionedNetexEntityIndex;
import org.entur.netex.support.NetexVersionHelper;
import org.rutebanken.netex.model.EntityInVersionStructure;
import org.rutebanken.netex.model.EntityStructure;

public class VersionedNetexEntityIndexImpl<V extends EntityInVersionStructure>
implements VersionedNetexEntityIndex<V> {
    private final Multimap<String, V> map = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
    private Map<String, V> latestMap = new ConcurrentHashMap<String, V>();

    @Override
    public V getLatestVersion(String id) {
        return (V)((EntityInVersionStructure)this.latestMap.get(id));
    }

    @Override
    public V getVersion(String id, String version) {
        return (V)NetexVersionHelper.versionOfElementIn(this.map.get((Object)id), version);
    }

    @Override
    public Collection<V> getLatestVersions() {
        return this.latestMap.values();
    }

    @Override
    public Collection<V> getAllVersions(String id) {
        return this.map.get((Object)id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Collection<V>> getAllVersions() {
        Multimap<String, V> multimap = this.map;
        synchronized (multimap) {
            return this.map.asMap();
        }
    }

    @Override
    public void putAll(Collection<V> entities) {
        entities.forEach(this::put);
        this.populateLatestMap();
    }

    private void put(V v) {
        this.map.put((Object)v.getId(), v);
    }

    private void populateLatestMap() {
        this.latestMap.putAll(this.map.keySet().stream().map(id -> NetexVersionHelper.latestVersionedElementIn(this.map.get(id))).collect(Collectors.toMap(EntityStructure::getId, e -> e)));
    }
}

