/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.loader.parser;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.JAXBElement;
import org.entur.netex.index.api.NetexEntitiesIndex;
import org.rutebanken.netex.model.Notice;
import org.rutebanken.netex.model.NoticeAssignment;
import org.rutebanken.netex.model.NoticeAssignmentsInFrame_RelStructure;
import org.rutebanken.netex.model.NoticesInFrame_RelStructure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NoticeParser {
    private static final Logger LOG = LoggerFactory.getLogger(NoticeParser.class);
    private final Collection<Notice> notices = new ArrayList<Notice>();
    private final Collection<NoticeAssignment> noticeAssignments = new ArrayList<NoticeAssignment>();

    NoticeParser() {
    }

    void parseNotices(NoticesInFrame_RelStructure notices) {
        if (notices == null) {
            return;
        }
        this.notices.addAll(notices.getNotice());
    }

    void parseNoticeAssignments(NoticeAssignmentsInFrame_RelStructure na) {
        if (na == null) {
            return;
        }
        for (JAXBElement it : na.getNoticeAssignment_()) {
            NoticeAssignment noticeAssignment = (NoticeAssignment)it.getValue();
            boolean error = false;
            if (noticeAssignment.getNoticedObjectRef() == null) {
                LOG.warn("Notice assignment is missing 'noticedObjectRef'. Id: {}", (Object)noticeAssignment.getId());
                error = true;
            }
            if (noticeAssignment.getNoticeRef() == null && noticeAssignment.getNotice() == null) {
                LOG.warn("Notice assignment have no 'notice' or 'noticeRef'. Id: {}", (Object)noticeAssignment.getId());
                error = true;
            }
            if (error) continue;
            this.noticeAssignments.add(noticeAssignment);
        }
    }

    void setResultOnIndex(NetexEntitiesIndex index) {
        index.getNoticeIndex().putAll(this.notices);
        index.getNoticeAssignmentIndex().putAll(this.noticeAssignments);
    }
}

