/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.index.impl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import java.util.Map;
import org.entur.netex.index.api.VersionedNetexEntityIndex;
import org.entur.netex.support.NetexVersionHelper;
import org.rutebanken.netex.model.EntityInVersionStructure;

public class VersionedNetexEntityIndexImpl<V extends EntityInVersionStructure>
implements VersionedNetexEntityIndex<V> {
    private final Multimap<String, V> map = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());

    @Override
    public V getLatestVersion(String id) {
        return (V)NetexVersionHelper.latestVersionedElementIn(this.map.get((Object)id));
    }

    @Override
    public V getVersion(String id, String version) {
        return (V)NetexVersionHelper.versionOfElementIn(this.map.get((Object)id), version);
    }

    @Override
    public Collection<V> getAllVersions(String id) {
        return this.map.get((Object)id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Collection<V>> getAllVersions() {
        Multimap<String, V> multimap = this.map;
        synchronized (multimap) {
            return this.map.asMap();
        }
    }

    @Override
    public void putAll(Collection<V> entities) {
        entities.forEach(this::put);
    }

    private void put(V v) {
        this.map.put((Object)v.getId(), v);
    }
}

