/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.support;

import java.util.Collection;
import java.util.Comparator;
import org.rutebanken.netex.model.EntityInVersionStructure;

public class NetexVersionHelper {
    private NetexVersionHelper() {
    }

    public static int versionOf(EntityInVersionStructure e) {
        return Integer.parseInt(e.getVersion());
    }

    public static int latestVersionIn(Collection<? extends EntityInVersionStructure> list) {
        return list.stream().mapToInt(NetexVersionHelper::versionOf).max().orElse(-1);
    }

    public static <T extends EntityInVersionStructure> T latestVersionedElementIn(Collection<T> list) {
        return (T)((EntityInVersionStructure)list.stream().max(NetexVersionHelper.comparingVersion()).orElse(null));
    }

    public static <T extends EntityInVersionStructure> Comparator<T> comparingVersion() {
        return Comparator.comparingInt(NetexVersionHelper::versionOf);
    }
}

