/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.gtfs.export.util;

import java.util.Collection;
import org.entur.netex.gtfs.export.repository.NetexDatasetRepository;
import org.rutebanken.netex.model.DatedServiceJourney;
import org.rutebanken.netex.model.ServiceAlterationEnumeration;
import org.rutebanken.netex.model.ServiceJourney;

public class ServiceAlterationChecker {
    private final NetexDatasetRepository netexDatasetRepository;

    public ServiceAlterationChecker(NetexDatasetRepository netexDatasetRepository) {
        this.netexDatasetRepository = netexDatasetRepository;
    }

    public boolean isReplacedOrCancelled(ServiceJourney serviceJourney) {
        return ServiceAlterationEnumeration.CANCELLATION == serviceJourney.getServiceAlteration() || ServiceAlterationEnumeration.REPLACED == serviceJourney.getServiceAlteration() || this.hasAllCancelledOrReplacedDatedServiceJourneys(serviceJourney);
    }

    private boolean hasAllCancelledOrReplacedDatedServiceJourneys(ServiceJourney serviceJourney) {
        Collection<DatedServiceJourney> datedServiceJourneys = this.netexDatasetRepository.getDatedServiceJourneysByServiceJourneyId(serviceJourney.getId());
        return !datedServiceJourneys.isEmpty() && datedServiceJourneys.stream().allMatch(this::isReplacedOrCancelled);
    }

    public boolean isReplacedOrCancelled(DatedServiceJourney datedServiceJourney) {
        return ServiceAlterationEnumeration.CANCELLATION == datedServiceJourney.getServiceAlteration() || ServiceAlterationEnumeration.REPLACED == datedServiceJourney.getServiceAlteration();
    }
}

