/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.gtfs.export.stop;

import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.entur.netex.gtfs.export.exception.QuayNotFoundException;
import org.entur.netex.gtfs.export.exception.StopPlaceNotFoundException;
import org.entur.netex.gtfs.export.loader.DefaultNetexDatasetLoader;
import org.entur.netex.gtfs.export.loader.NetexDatasetLoader;
import org.entur.netex.gtfs.export.repository.DefaultNetexDatasetRepository;
import org.entur.netex.gtfs.export.stop.NetexEntityFetcher;
import org.entur.netex.gtfs.export.stop.StopAreaRepository;
import org.entur.netex.index.api.NetexEntitiesIndex;
import org.rutebanken.netex.model.Quay;
import org.rutebanken.netex.model.StopPlace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStopAreaRepository
implements StopAreaRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultStopAreaRepository.class);
    private Map<String, StopPlace> stopPlaceByQuayId;
    private Map<String, Quay> quayById;
    private final NetexDatasetLoader netexDatasetLoader = new DefaultNetexDatasetLoader();
    private final NetexEntityFetcher<Quay, String> quayFetcher;
    private final NetexEntityFetcher<StopPlace, String> stopPlaceFetcher;

    public DefaultStopAreaRepository() {
        this(quayId -> {
            throw new QuayNotFoundException("Could not find Quay for id " + quayId);
        }, quayId -> {
            throw new StopPlaceNotFoundException("Could not find StopPlace for quay id " + quayId);
        });
    }

    public DefaultStopAreaRepository(NetexEntityFetcher<Quay, String> quayFetcher, NetexEntityFetcher<StopPlace, String> stopPlaceFetcher) {
        this.quayFetcher = quayFetcher;
        this.stopPlaceFetcher = stopPlaceFetcher;
    }

    public void loadStopAreas(InputStream stopDataset) {
        LOGGER.info("Importing NeTEx Stop dataset");
        DefaultNetexDatasetRepository netexStopRepository = new DefaultNetexDatasetRepository();
        this.netexDatasetLoader.load(stopDataset, netexStopRepository);
        NetexEntitiesIndex netexStopEntitiesIndex = netexStopRepository.getIndex();
        this.stopPlaceByQuayId = netexStopEntitiesIndex.getStopPlaceIdByQuayIdIndex().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (StopPlace)netexStopEntitiesIndex.getStopPlaceIndex().getLatestVersion((String)entry.getValue())));
        this.quayById = netexStopEntitiesIndex.getQuayIndex().getAllVersions().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> (Quay)netexStopEntitiesIndex.getQuayIndex().getLatestVersion((String)entry.getKey())));
        LOGGER.info("Imported NeTEx Stop dataset");
    }

    @Override
    public StopPlace getStopPlaceByQuayId(String quayId) {
        StopPlace stopPlace = this.stopPlaceByQuayId.get(quayId);
        if (stopPlace == null) {
            return this.stopPlaceFetcher.tryFetch(quayId);
        }
        return stopPlace;
    }

    @Override
    public Collection<Quay> getAllQuays() {
        return this.quayById.values();
    }

    @Override
    public Quay getQuayById(String quayId) {
        Quay quay = this.quayById.get(quayId);
        if (quay == null) {
            return this.quayFetcher.tryFetch(quayId);
        }
        return quay;
    }
}

