/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.gtfs.export.producer;

import org.entur.netex.gtfs.export.exception.InvalidAuthorityUrlException;
import org.entur.netex.gtfs.export.producer.AgencyProducer;
import org.entur.netex.gtfs.export.repository.NetexDatasetRepository;
import org.onebusaway.gtfs.model.Agency;
import org.rutebanken.netex.model.Authority;
import org.rutebanken.netex.model.ContactStructure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAgencyProducer
implements AgencyProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAgencyProducer.class);
    private final NetexDatasetRepository netexDatasetRepository;

    public DefaultAgencyProducer(NetexDatasetRepository netexDatasetRepository) {
        this.netexDatasetRepository = netexDatasetRepository;
    }

    @Override
    public Agency produce(Authority authority) {
        String timeZone = this.netexDatasetRepository.getTimeZone();
        Agency agency = new Agency();
        agency.setId(authority.getId());
        agency.setName(authority.getName().getValue());
        ContactStructure contactDetails = authority.getContactDetails();
        if (contactDetails != null) {
            String url = contactDetails.getUrl();
            if (url != null && !url.isBlank()) {
                if (!DefaultAgencyProducer.isValidGtfsUrl(url)) {
                    throw new InvalidAuthorityUrlException("Invalid URL for authority " + authority.getId());
                }
            } else {
                throw new InvalidAuthorityUrlException("Missing URL for authority " + authority.getId());
            }
            agency.setUrl(url);
        } else {
            throw new InvalidAuthorityUrlException("Missing Contact details for authority " + authority.getId());
        }
        agency.setPhone(contactDetails.getPhone());
        agency.setTimezone(timeZone);
        return agency;
    }

    private static boolean isValidGtfsUrl(String url) {
        return url.startsWith("http://") || url.startsWith("https://");
    }
}

