/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.gtfs.export.serializer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.entur.netex.gtfs.export.exception.GtfsExportException;
import org.entur.netex.gtfs.export.exception.GtfsSerializationException;
import org.entur.netex.gtfs.export.serializer.FilteredFieldsGtfsWriter;
import org.entur.netex.gtfs.export.serializer.GtfsSerializer;
import org.onebusaway.csv_entities.exceptions.CsvException;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.onebusaway.gtfs.services.GtfsDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultGtfsSerializer
implements GtfsSerializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultGtfsSerializer.class);
    private static final Map<Class<?>, Collection<String>> FILTERED_FIELDS = Map.of(Route.class, List.of("eligibility_restricted"), StopTime.class, List.of("continuous_pickup", "continuous_drop_off", "start_service_area_radius", "end_service_area_radius", "departure_buffer"), Trip.class, List.of("drt_advance_book_min", "peak_offpeak"));

    @Override
    public InputStream writeGtfs(GtfsDao gtfsDao) {
        LOGGER.info("Exporting GTFS archive");
        FilteredFieldsGtfsWriter writer = null;
        try {
            File outputFile = DefaultGtfsSerializer.createSecureTemporaryFile("gtfs-export-", ".zip");
            writer = new FilteredFieldsGtfsWriter(FILTERED_FIELDS);
            writer.setOutputLocation(outputFile);
            writer.run(gtfsDao);
            InputStream inputStream = DefaultGtfsSerializer.createDeleteOnCloseInputStream(outputFile);
            return inputStream;
        }
        catch (CsvException csve) {
            throw new GtfsExportException("Cannot produce a valid GTFS dataset", csve);
        }
        catch (IOException e) {
            throw new GtfsSerializationException("Error while saving the GTFS dataset", e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Error while closing the GTFS writer", (Throwable)e);
                }
            }
        }
    }

    private static File createSecureTemporaryFile(String prefix, String suffix) throws IOException {
        File outputFile = Files.createTempFile(prefix, suffix, new FileAttribute[0]).toFile();
        boolean setReadableSucceeded = outputFile.setReadable(true, true);
        boolean setWritableSucceeded = outputFile.setWritable(true, true);
        boolean setExecutableSucceeded = outputFile.setExecutable(false);
        if (!(setReadableSucceeded && setWritableSucceeded && setExecutableSucceeded)) {
            LOGGER.warn("Could not set permissions on temporary file {}", (Object)outputFile.getCanonicalPath());
        }
        return outputFile;
    }

    private static InputStream createDeleteOnCloseInputStream(File tmpFile) {
        try {
            return Files.newInputStream(tmpFile.toPath(), StandardOpenOption.DELETE_ON_CLOSE);
        }
        catch (IOException e) {
            throw new GtfsSerializationException("Error while creating the input stream for the GTFS archive", e);
        }
    }
}

