/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.gtfs.export.producer;

import java.util.Optional;
import org.entur.netex.gtfs.export.producer.TransferProducer;
import org.entur.netex.gtfs.export.repository.GtfsDatasetRepository;
import org.entur.netex.gtfs.export.repository.NetexDatasetRepository;
import org.entur.netex.gtfs.export.util.StopUtil;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.Transfer;
import org.onebusaway.gtfs.model.Trip;
import org.rutebanken.netex.model.ServiceJourneyInterchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTransferProducer
implements TransferProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTransferProducer.class);
    private final NetexDatasetRepository netexDatasetRepository;
    private final GtfsDatasetRepository gtfsDatasetRepository;
    private final boolean generateStaySeatedTransfer;

    public DefaultTransferProducer(NetexDatasetRepository netexDatasetRepository, GtfsDatasetRepository gtfsDatasetRepository) {
        this(netexDatasetRepository, gtfsDatasetRepository, false);
    }

    public DefaultTransferProducer(NetexDatasetRepository netexDatasetRepository, GtfsDatasetRepository gtfsDatasetRepository, boolean generateStaySeatedTransfer) {
        this.netexDatasetRepository = netexDatasetRepository;
        this.gtfsDatasetRepository = gtfsDatasetRepository;
        this.generateStaySeatedTransfer = generateStaySeatedTransfer;
    }

    @Override
    public Transfer produce(ServiceJourneyInterchange serviceJourneyInterchange) {
        String fromServiceJourneyId = serviceJourneyInterchange.getFromJourneyRef().getRef();
        Optional<Trip> fromTrip = this.gtfsDatasetRepository.findTripById(fromServiceJourneyId);
        String toServiceJourneyId = serviceJourneyInterchange.getToJourneyRef().getRef();
        Optional<Trip> toTrip = this.gtfsDatasetRepository.findTripById(toServiceJourneyId);
        if (fromTrip.isEmpty() || toTrip.isEmpty()) {
            LOGGER.info("Ignoring transfer {} from {} to {}: the source or destination trip is not valid", new Object[]{serviceJourneyInterchange, fromServiceJourneyId, toServiceJourneyId});
            return null;
        }
        Transfer transfer = new Transfer();
        transfer.setFromTrip(fromTrip.get());
        transfer.setToTrip(toTrip.get());
        String fromScheduledStopPointId = serviceJourneyInterchange.getFromPointRef().getRef();
        Stop fromStop = StopUtil.getGtfsStopFromScheduledStopPointId(fromScheduledStopPointId, this.netexDatasetRepository, this.gtfsDatasetRepository);
        transfer.setFromStop(fromStop);
        String toScheduledStopPointId = serviceJourneyInterchange.getToPointRef().getRef();
        Stop toStop = StopUtil.getGtfsStopFromScheduledStopPointId(toScheduledStopPointId, this.netexDatasetRepository, this.gtfsDatasetRepository);
        transfer.setToStop(toStop);
        if (this.generateStaySeatedTransfer && Boolean.TRUE.equals(serviceJourneyInterchange.isStaySeated())) {
            transfer.setTransferType(4);
        } else if (Boolean.TRUE.equals(serviceJourneyInterchange.isGuaranteed())) {
            transfer.setTransferType(1);
        } else if (serviceJourneyInterchange.getMinimumTransferTime() != null) {
            transfer.setTransferType(2);
            transfer.setMinTransferTime((int)serviceJourneyInterchange.getMinimumTransferTime().getSeconds());
        } else if (serviceJourneyInterchange.getPriority() != null && serviceJourneyInterchange.getPriority().intValueExact() < 0) {
            transfer.setTransferType(3);
        } else {
            transfer.setTransferType(0);
        }
        return transfer;
    }
}

