/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.gtfs.export.producer;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.entur.netex.gtfs.export.producer.ServiceCalendarDateProducer;
import org.entur.netex.gtfs.export.repository.GtfsDatasetRepository;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.ServiceCalendarDate;
import org.onebusaway.gtfs.model.calendar.ServiceDate;

public class DefaultServiceCalendarDateProducer
implements ServiceCalendarDateProducer {
    private final Agency agency;

    public DefaultServiceCalendarDateProducer(GtfsDatasetRepository gtfsDatasetRepository) {
        this.agency = gtfsDatasetRepository.getDefaultAgency();
    }

    @Override
    public ServiceCalendarDate produce(String serviceId, LocalDateTime date, boolean isAvailable) {
        ServiceCalendarDate serviceCalendarDate = new ServiceCalendarDate();
        AgencyAndId serviceCalendarDateAgencyAndId = new AgencyAndId();
        serviceCalendarDateAgencyAndId.setId(serviceId);
        serviceCalendarDateAgencyAndId.setAgencyId(this.agency.getId());
        serviceCalendarDate.setServiceId(serviceCalendarDateAgencyAndId);
        serviceCalendarDate.setDate(new ServiceDate(DefaultServiceCalendarDateProducer.toGtfsDate(date)));
        serviceCalendarDate.setExceptionType(isAvailable ? 1 : 2);
        return serviceCalendarDate;
    }

    private static Date toGtfsDate(LocalDateTime netexDate) {
        return Date.from(netexDate.atZone(ZoneId.systemDefault()).toInstant());
    }
}

