/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.gtfs.export.producer;

import jakarta.xml.bind.annotation.adapters.HexBinaryAdapter;
import org.entur.netex.gtfs.export.producer.RouteProducer;
import org.entur.netex.gtfs.export.repository.GtfsDatasetRepository;
import org.entur.netex.gtfs.export.repository.NetexDatasetRepository;
import org.entur.netex.gtfs.export.util.TransportModeUtil;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Route;
import org.rutebanken.netex.model.Line;
import org.rutebanken.netex.model.PresentationStructure;

public class DefaultRouteProducer
implements RouteProducer {
    private final HexBinaryAdapter hexBinaryAdapter;
    private final NetexDatasetRepository netexDatasetRepository;
    private final GtfsDatasetRepository gtfsDatasetRepository;

    public DefaultRouteProducer(NetexDatasetRepository netexDatasetRepository, GtfsDatasetRepository gtfsDatasetRepository) {
        this.netexDatasetRepository = netexDatasetRepository;
        this.gtfsDatasetRepository = gtfsDatasetRepository;
        this.hexBinaryAdapter = new HexBinaryAdapter();
    }

    @Override
    public Route produce(Line line) {
        String lineId = line.getId();
        Route route = new Route();
        String authorityId = this.netexDatasetRepository.getAuthorityIdForLine(line);
        Agency agency = this.gtfsDatasetRepository.getAgencyById(authorityId);
        route.setAgency(agency);
        AgencyAndId agencyAndId = new AgencyAndId();
        agencyAndId.setId(lineId);
        agencyAndId.setAgencyId(agency.getId());
        route.setId(agencyAndId);
        route.setShortName(line.getPublicCode());
        if (line.getShortName() != null && line.getShortName().getValue() != null) {
            route.setLongName(line.getShortName().getValue());
        } else {
            route.setLongName(line.getName().getValue());
        }
        if (route.getLongName() != null && route.getLongName().equals(route.getShortName())) {
            route.setLongName(null);
        }
        if (line.getDescription() != null) {
            route.setDesc(line.getDescription().getValue());
        }
        route.setUrl(line.getUrl());
        route.setType(TransportModeUtil.getGtfsExtendedRouteType(line));
        PresentationStructure presentation = line.getPresentation();
        if (presentation != null) {
            route.setColor(this.hexBinaryAdapter.marshal(presentation.getColour()));
            route.setTextColor(this.hexBinaryAdapter.marshal(presentation.getTextColour()));
        }
        return route;
    }
}

