/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.gtfs.export.model;

import java.time.LocalDateTime;
import java.util.HashSet;
import java.util.Set;
import org.entur.netex.gtfs.export.model.ServiceCalendarPeriod;

public class GtfsService {
    private final String id;
    private ServiceCalendarPeriod serviceCalendarPeriod;
    private final Set<LocalDateTime> includedDates = new HashSet<LocalDateTime>();
    private final Set<LocalDateTime> excludedDates = new HashSet<LocalDateTime>();

    public GtfsService(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void addExcludedDate(LocalDateTime date) {
        this.excludedDates.add(date);
    }

    public void addIncludedDate(LocalDateTime date) {
        this.includedDates.add(date);
    }

    public Set<LocalDateTime> getIncludedDates() {
        return new HashSet<LocalDateTime>(this.includedDates);
    }

    public Set<LocalDateTime> getExcludedDates() {
        return new HashSet<LocalDateTime>(this.excludedDates);
    }

    public ServiceCalendarPeriod getServiceCalendarPeriod() {
        return this.serviceCalendarPeriod;
    }

    public void setServiceCalendarPeriod(ServiceCalendarPeriod serviceCalendarPeriod) {
        this.serviceCalendarPeriod = serviceCalendarPeriod;
    }

    public void removeIncludedDates(Set<LocalDateTime> removedIncludedDates) {
        this.includedDates.removeAll(removedIncludedDates);
    }

    public void removeAllExcludedDates() {
        this.excludedDates.clear();
    }
}

