/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.gtfs.export.util;

import java.util.Objects;
import java.util.stream.Collectors;
import org.entur.netex.gtfs.export.repository.NetexDatasetRepository;
import org.rutebanken.netex.model.DestinationDisplay;
import org.rutebanken.netex.model.DestinationDisplay_VersionStructure;
import org.rutebanken.netex.model.JourneyPattern;
import org.rutebanken.netex.model.MultilingualString;
import org.rutebanken.netex.model.StopPointInJourneyPattern;

public final class DestinationDisplayUtil {
    private DestinationDisplayUtil() {
    }

    public static DestinationDisplay getInitialDestinationDisplay(JourneyPattern journeyPattern, NetexDatasetRepository netexDatasetRepository) {
        StopPointInJourneyPattern firstStopPointInJourneyPattern = (StopPointInJourneyPattern)journeyPattern.getPointsInSequence().getPointInJourneyPatternOrStopPointInJourneyPatternOrTimingPointInJourneyPattern().get(0);
        return netexDatasetRepository.getDestinationDisplayById(firstStopPointInJourneyPattern.getDestinationDisplayRef().getRef());
    }

    public static String getHeadSignFromDestinationDisplay(DestinationDisplay destinationDisplay, NetexDatasetRepository netexDatasetRepository) {
        if (destinationDisplay == null) {
            return null;
        }
        Object frontText = destinationDisplay.getFrontText().getValue();
        String via = "";
        if (destinationDisplay.getVias() != null) {
            via = destinationDisplay.getVias().getVia().stream().map(netexVia -> netexVia.getDestinationDisplayRef().getRef()).map(netexDatasetRepository::getDestinationDisplayById).map(DestinationDisplay_VersionStructure::getFrontText).filter(Objects::nonNull).map(MultilingualString::getValue).collect(Collectors.joining("/"));
        }
        if (!via.isEmpty()) {
            frontText = (String)frontText + " via " + via;
        }
        return frontText;
    }
}

