/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.gtfs.export.repository;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.entur.netex.gtfs.export.exception.DefaultTimeZoneException;
import org.entur.netex.gtfs.export.exception.GtfsExportException;
import org.entur.netex.gtfs.export.exception.QuayNotFoundException;
import org.entur.netex.gtfs.export.repository.NetexDatasetRepository;
import org.entur.netex.index.api.NetexEntitiesIndex;
import org.entur.netex.index.impl.NetexEntitiesIndexImpl;
import org.rutebanken.netex.model.Authority;
import org.rutebanken.netex.model.DatedServiceJourney;
import org.rutebanken.netex.model.DayType;
import org.rutebanken.netex.model.DayTypeAssignment;
import org.rutebanken.netex.model.DayTypeRefStructure;
import org.rutebanken.netex.model.DestinationDisplay;
import org.rutebanken.netex.model.JourneyPattern;
import org.rutebanken.netex.model.JourneyPatternRefStructure;
import org.rutebanken.netex.model.Line;
import org.rutebanken.netex.model.LineRefStructure;
import org.rutebanken.netex.model.LocaleStructure;
import org.rutebanken.netex.model.Network;
import org.rutebanken.netex.model.OperatingDay;
import org.rutebanken.netex.model.OperatingPeriod;
import org.rutebanken.netex.model.OperatingPeriodRefStructure;
import org.rutebanken.netex.model.Route;
import org.rutebanken.netex.model.ServiceJourney;
import org.rutebanken.netex.model.ServiceJourneyInterchange;
import org.rutebanken.netex.model.ServiceLink;
import org.rutebanken.netex.model.TransportOrganisationRefStructure;
import org.rutebanken.netex.model.VersionFrameDefaultsStructure;
import org.rutebanken.netex.model.VersionFrame_VersionStructure;

public class DefaultNetexDatasetRepository
implements NetexDatasetRepository {
    private final NetexEntitiesIndex netexEntitiesIndex = new NetexEntitiesIndexImpl();
    private volatile String timezone;

    @Override
    public NetexEntitiesIndex getIndex() {
        return this.netexEntitiesIndex;
    }

    @Override
    public OperatingDay getOperatingDayByDayTypeAssignment(DayTypeAssignment dayTypeAssignment) {
        if (dayTypeAssignment.getOperatingDayRef() == null) {
            throw new GtfsExportException("OperatingDay undefined for DayTypeAssignment " + dayTypeAssignment.getId());
        }
        OperatingDay operatingDay = (OperatingDay)this.netexEntitiesIndex.getOperatingDayIndex().get(dayTypeAssignment.getOperatingDayRef().getRef());
        if (operatingDay == null) {
            throw new GtfsExportException("OperatingDay not found: " + dayTypeAssignment.getOperatingDayRef());
        }
        return operatingDay;
    }

    @Override
    public OperatingPeriod getOperatingPeriodByDayTypeAssignment(DayTypeAssignment dayTypeAssignment) {
        if (dayTypeAssignment.getOperatingPeriodRef() == null) {
            throw new GtfsExportException("OperatingPeriod undefined for DayTypeAssignment " + dayTypeAssignment.getId());
        }
        OperatingPeriod operatingPeriod = (OperatingPeriod)this.netexEntitiesIndex.getOperatingPeriodIndex().get(((OperatingPeriodRefStructure)dayTypeAssignment.getOperatingPeriodRef().getValue()).getRef());
        if (operatingPeriod == null) {
            throw new GtfsExportException("OperatingPeriod not found: " + dayTypeAssignment.getOperatingPeriodRef());
        }
        return operatingPeriod;
    }

    @Override
    public DayType getDayTypeByDayTypeAssignment(DayTypeAssignment dayTypeAssignment) {
        String dayTypeId = ((DayTypeRefStructure)dayTypeAssignment.getDayTypeRef().getValue()).getRef();
        DayType dayType = (DayType)this.netexEntitiesIndex.getDayTypeIndex().get(dayTypeId);
        if (dayType == null) {
            throw new GtfsExportException("DayType not found: " + dayTypeId);
        }
        return dayType;
    }

    @Override
    public String getTimeZone() {
        if (this.timezone == null) {
            Set timeZones = this.netexEntitiesIndex.getCompositeFrames().stream().map(VersionFrame_VersionStructure::getFrameDefaults).filter(Objects::nonNull).map(VersionFrameDefaultsStructure::getDefaultLocale).filter(Objects::nonNull).map(LocaleStructure::getTimeZone).collect(Collectors.toSet());
            if (timeZones.size() > 1) {
                throw new DefaultTimeZoneException("The dataset contains more than one default timezone");
            }
            this.timezone = (String)timeZones.stream().findFirst().orElseThrow(() -> new DefaultTimeZoneException("The dataset does not contain a default timezone"));
        }
        return this.timezone;
    }

    @Override
    public String getAuthorityIdForLine(Line line) {
        Network network = this.findNetwork(line.getRepresentedByGroupRef().getRef());
        return ((TransportOrganisationRefStructure)network.getTransportOrganisationRef().getValue()).getRef();
    }

    private Network findNetwork(String networkOrGroupOfLinesRef) {
        Network network = (Network)this.netexEntitiesIndex.getNetworkIndex().get(networkOrGroupOfLinesRef);
        if (network != null) {
            return network;
        }
        return this.netexEntitiesIndex.getNetworkIndex().getAll().stream().filter(n -> n.getGroupsOfLines() != null).filter(n -> n.getGroupsOfLines().getGroupOfLines().stream().anyMatch(groupOfLine -> groupOfLine.getId().equals(networkOrGroupOfLinesRef))).findFirst().orElseThrow(() -> new GtfsExportException("Could not find Network for network or group of lines id " + networkOrGroupOfLinesRef));
    }

    @Override
    public Collection<Line> getLines() {
        return this.netexEntitiesIndex.getLineIndex().getAll();
    }

    @Override
    public Collection<ServiceJourney> getServiceJourneys() {
        return this.netexEntitiesIndex.getServiceJourneyIndex().getAll();
    }

    @Override
    public Collection<ServiceJourneyInterchange> getServiceJourneyInterchanges() {
        return this.netexEntitiesIndex.getServiceJourneyInterchangeIndex().getAll();
    }

    @Override
    public Collection<DayTypeAssignment> getDayTypeAssignmentsByDayType(DayType dayType) {
        return this.netexEntitiesIndex.getDayTypeAssignmentsByDayTypeIdIndex().get((Object)dayType.getId());
    }

    @Override
    public Authority getAuthorityById(String authorityId) {
        return (Authority)this.netexEntitiesIndex.getAuthorityIndex().get(authorityId);
    }

    @Override
    public ServiceJourney getServiceJourneyById(String serviceJourneyId) {
        return (ServiceJourney)this.netexEntitiesIndex.getServiceJourneyIndex().get(serviceJourneyId);
    }

    @Override
    public String getFlexibleStopPlaceIdByScheduledStopPointId(String scheduledStopPointId) {
        return (String)this.netexEntitiesIndex.getFlexibleStopPlaceIdByStopPointRefIndex().get(scheduledStopPointId);
    }

    @Override
    public String getQuayIdByScheduledStopPointId(String scheduledStopPointId) {
        String quayId = (String)this.netexEntitiesIndex.getQuayIdByStopPointRefIndex().get(scheduledStopPointId);
        if (quayId == null) {
            throw new QuayNotFoundException("Could not find Quay id for scheduled stop point id " + scheduledStopPointId);
        }
        return quayId;
    }

    @Override
    public JourneyPattern getJourneyPatternById(String journeyPatternId) {
        return (JourneyPattern)this.netexEntitiesIndex.getJourneyPatternIndex().get(journeyPatternId);
    }

    @Override
    public Collection<ServiceJourney> getServiceJourneysByJourneyPattern(JourneyPattern journeyPattern) {
        return this.getServiceJourneys().stream().filter(serviceJourney -> ((JourneyPatternRefStructure)serviceJourney.getJourneyPatternRef().getValue()).getRef().equals(journeyPattern.getId())).collect(Collectors.toSet());
    }

    @Override
    public Collection<Route> getRoutesByLine(Line line) {
        return this.netexEntitiesIndex.getRouteIndex().getAll().stream().filter(route -> ((LineRefStructure)route.getLineRef().getValue()).getRef().equals(line.getId())).collect(Collectors.toSet());
    }

    @Override
    public Collection<JourneyPattern> getJourneyPatternsByRoute(Route route) {
        return this.netexEntitiesIndex.getJourneyPatternIndex().getAll().stream().filter(journeyPattern -> journeyPattern.getRouteRef().getRef().equals(route.getId())).collect(Collectors.toSet());
    }

    @Override
    public ServiceLink getServiceLinkById(String serviceLinkId) {
        return (ServiceLink)this.netexEntitiesIndex.getServiceLinkIndex().get(serviceLinkId);
    }

    @Override
    public DestinationDisplay getDestinationDisplayById(String destinationDisplayId) {
        return (DestinationDisplay)this.netexEntitiesIndex.getDestinationDisplayIndex().get(destinationDisplayId);
    }

    @Override
    public Collection<DatedServiceJourney> getDatedServiceJourneysByServiceJourneyId(String serviceJourneyId) {
        return this.netexEntitiesIndex.getDatedServiceJourneyByServiceJourneyRefIndex().get((Object)serviceJourneyId);
    }

    @Override
    public DayType getDayTypeById(String dayTypeId) {
        DayType dayType = (DayType)this.netexEntitiesIndex.getDayTypeIndex().get(dayTypeId);
        if (dayType == null) {
            throw new GtfsExportException("Could not find DayType with id " + dayTypeId);
        }
        return dayType;
    }

    @Override
    public OperatingDay getOperatingDayById(String operatingDayId) {
        OperatingDay operatingDay = (OperatingDay)this.netexEntitiesIndex.getOperatingDayIndex().get(operatingDayId);
        if (operatingDay == null) {
            throw new GtfsExportException("Could not find OperatingDay with id " + operatingDayId);
        }
        return operatingDay;
    }
}

