/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.gtfs.export.producer;

import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.entur.netex.gtfs.export.producer.GtfsServiceRepository;
import org.entur.netex.gtfs.export.producer.TripProducer;
import org.entur.netex.gtfs.export.repository.GtfsDatasetRepository;
import org.entur.netex.gtfs.export.repository.NetexDatasetRepository;
import org.entur.netex.gtfs.export.util.DestinationDisplayUtil;
import org.entur.netex.gtfs.export.util.ServiceAlterationChecker;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.Trip;
import org.rutebanken.netex.model.DayType;
import org.rutebanken.netex.model.DayTypeRefStructure;
import org.rutebanken.netex.model.DestinationDisplay;
import org.rutebanken.netex.model.DirectionTypeEnumeration;
import org.rutebanken.netex.model.OperatingDay;
import org.rutebanken.netex.model.Route;
import org.rutebanken.netex.model.ServiceJourney;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTripProducer
implements TripProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTripProducer.class);
    private final Agency agency;
    private final GtfsServiceRepository gtfsServiceRepository;
    private final NetexDatasetRepository netexDatasetRepository;
    private final ServiceAlterationChecker serviceAlterationChecker;

    public DefaultTripProducer(NetexDatasetRepository netexDatasetRepository, GtfsDatasetRepository gtfsDatasetRepository, GtfsServiceRepository gtfsServiceRepository) {
        this.agency = gtfsDatasetRepository.getDefaultAgency();
        this.gtfsServiceRepository = gtfsServiceRepository;
        this.netexDatasetRepository = netexDatasetRepository;
        this.serviceAlterationChecker = new ServiceAlterationChecker(netexDatasetRepository);
    }

    @Override
    public Trip produce(ServiceJourney serviceJourney, Route netexRoute, org.onebusaway.gtfs.model.Route gtfsRoute, AgencyAndId shapeId, DestinationDisplay initialDestinationDisplay) {
        if (this.serviceAlterationChecker.isReplacedOrCancelled(serviceJourney)) {
            return null;
        }
        String tripId = serviceJourney.getId();
        AgencyAndId tripAgencyAndId = new AgencyAndId();
        tripAgencyAndId.setId(tripId);
        tripAgencyAndId.setAgencyId(this.agency.getId());
        Trip trip = new Trip();
        trip.setId(tripAgencyAndId);
        AgencyAndId serviceAgencyAndId = new AgencyAndId();
        trip.setRoute(gtfsRoute);
        DirectionTypeEnumeration directionType = netexRoute.getDirectionType();
        if (DirectionTypeEnumeration.INBOUND == directionType) {
            trip.setDirectionId("1");
        } else {
            trip.setDirectionId("0");
        }
        if (serviceJourney.getDayTypes() != null) {
            Set<DayType> dayTypes = serviceJourney.getDayTypes().getDayTypeRef().stream().map(jaxbElement -> ((DayTypeRefStructure)jaxbElement.getValue()).getRef()).map(this.netexDatasetRepository::getDayTypeById).filter(dayType -> !this.netexDatasetRepository.getDayTypeAssignmentsByDayType((DayType)dayType).isEmpty()).collect(Collectors.toSet());
            if (dayTypes.isEmpty()) {
                LOGGER.info("Skipping ServiceJourney {} without DayTypeAssignment", (Object)serviceJourney.getId());
                return null;
            }
            serviceAgencyAndId.setId(this.gtfsServiceRepository.getServiceForDayTypes(dayTypes).getId());
        } else {
            LOGGER.trace("Producing trip based on DatedServiceJourneys for ServiceJourney {}", (Object)serviceJourney.getId());
            Set<OperatingDay> operatingDays = this.netexDatasetRepository.getDatedServiceJourneysByServiceJourneyId(serviceJourney.getId()).stream().filter(Predicate.not(this.serviceAlterationChecker::isReplacedOrCancelled)).map(datedServiceJourney -> this.netexDatasetRepository.getOperatingDayById(datedServiceJourney.getOperatingDayRef().getRef())).collect(Collectors.toSet());
            if (operatingDays.isEmpty()) {
                LOGGER.trace("Filtering ServiceJourney where all DatedServiceJourneys are replaced or cancelled: {}", (Object)serviceJourney.getId());
                return null;
            }
            serviceAgencyAndId.setId(this.gtfsServiceRepository.getServiceForOperatingDays(operatingDays).getId());
        }
        serviceAgencyAndId.setAgencyId(this.agency.getId());
        trip.setServiceId(serviceAgencyAndId);
        trip.setTripHeadsign(DestinationDisplayUtil.getHeadSignFromDestinationDisplay(initialDestinationDisplay, this.netexDatasetRepository));
        trip.setShapeId(shapeId);
        return trip;
    }
}

