/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.gtfs.export.producer;

import org.entur.netex.gtfs.export.exception.GtfsExportException;
import org.entur.netex.gtfs.export.model.GtfsShape;
import org.entur.netex.gtfs.export.producer.StopTimeProducer;
import org.entur.netex.gtfs.export.repository.GtfsDatasetRepository;
import org.entur.netex.gtfs.export.repository.NetexDatasetRepository;
import org.entur.netex.gtfs.export.util.DestinationDisplayUtil;
import org.entur.netex.gtfs.export.util.GtfsUtil;
import org.entur.netex.gtfs.export.util.StopUtil;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.model.StopLocation;
import org.onebusaway.gtfs.model.StopTime;
import org.onebusaway.gtfs.model.Trip;
import org.rutebanken.netex.model.DestinationDisplay;
import org.rutebanken.netex.model.JourneyPattern;
import org.rutebanken.netex.model.PointInJourneyPatternRefStructure;
import org.rutebanken.netex.model.ScheduledStopPointRefStructure;
import org.rutebanken.netex.model.StopPointInJourneyPattern;
import org.rutebanken.netex.model.TimetabledPassingTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStopTimeProducer
implements StopTimeProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultStopTimeProducer.class);
    private final NetexDatasetRepository netexDatasetRepository;
    private final GtfsDatasetRepository gtfsDatasetRepository;

    public DefaultStopTimeProducer(NetexDatasetRepository netexDatasetRepository, GtfsDatasetRepository gtfsDatasetRepository) {
        this.netexDatasetRepository = netexDatasetRepository;
        this.gtfsDatasetRepository = gtfsDatasetRepository;
    }

    @Override
    public StopTime produce(TimetabledPassingTime timetabledPassingTime, JourneyPattern journeyPattern, Trip trip, GtfsShape gtfsShape, String currentHeadSign) {
        DestinationDisplay destinationDisplay;
        int dayOffset;
        StopTime stopTime = new StopTime();
        stopTime.setTrip(trip);
        String pointInJourneyPatternRef = ((PointInJourneyPatternRefStructure)timetabledPassingTime.getPointInJourneyPatternRef().getValue()).getRef();
        StopPointInJourneyPattern stopPointInSequence = (StopPointInJourneyPattern)journeyPattern.getPointsInSequence().getPointInJourneyPatternOrStopPointInJourneyPatternOrTimingPointInJourneyPattern().stream().filter(stopPointInJourneyPattern -> stopPointInJourneyPattern.getId().equals(pointInJourneyPatternRef)).findFirst().orElseThrow(() -> new GtfsExportException("Could not find StopPointInJourneyPattern with id " + pointInJourneyPatternRef));
        int stopSequence = stopPointInSequence.getOrder().intValueExact();
        stopTime.setStopSequence(stopSequence);
        String scheduledStopPointId = ((ScheduledStopPointRefStructure)stopPointInSequence.getScheduledStopPointRef().getValue()).getRef();
        Stop stop = StopUtil.getGtfsStopFromScheduledStopPointId(scheduledStopPointId, this.netexDatasetRepository, this.gtfsDatasetRepository);
        stopTime.setStop((StopLocation)stop);
        if (timetabledPassingTime.getArrivalTime() != null) {
            dayOffset = timetabledPassingTime.getArrivalDayOffset() == null ? 0 : timetabledPassingTime.getArrivalDayOffset().intValueExact();
            stopTime.setArrivalTime(GtfsUtil.toGtfsTimeWithDayOffset(timetabledPassingTime.getArrivalTime(), dayOffset));
            if (timetabledPassingTime.getDepartureTime() == null) {
                stopTime.setDepartureTime(stopTime.getArrivalTime());
            }
        }
        if (timetabledPassingTime.getDepartureTime() != null) {
            dayOffset = timetabledPassingTime.getDepartureDayOffset() == null ? 0 : timetabledPassingTime.getDepartureDayOffset().intValueExact();
            stopTime.setDepartureTime(GtfsUtil.toGtfsTimeWithDayOffset(timetabledPassingTime.getDepartureTime(), dayOffset));
            if (timetabledPassingTime.getArrivalTime() == null) {
                stopTime.setArrivalTime(stopTime.getDepartureTime());
            }
        }
        String stopHeadSignOnCurrentStop = null;
        if (stopPointInSequence.getDestinationDisplayRef() != null && (stopHeadSignOnCurrentStop = DestinationDisplayUtil.getHeadSignFromDestinationDisplay(destinationDisplay = this.netexDatasetRepository.getDestinationDisplayById(stopPointInSequence.getDestinationDisplayRef().getRef()), this.netexDatasetRepository)) != null && stopHeadSignOnCurrentStop.equals(trip.getTripHeadsign())) {
            stopHeadSignOnCurrentStop = null;
        }
        if (stopHeadSignOnCurrentStop == null) {
            stopHeadSignOnCurrentStop = currentHeadSign;
        }
        stopTime.setStopHeadsign(stopHeadSignOnCurrentStop);
        if (Boolean.FALSE.equals(stopPointInSequence.isForBoarding())) {
            stopTime.setPickupType(1);
        }
        if (Boolean.FALSE.equals(stopPointInSequence.isForAlighting())) {
            stopTime.setDropOffType(1);
        }
        if (Boolean.TRUE.equals(stopPointInSequence.isRequestStop())) {
            stopTime.setPickupType(3);
            stopTime.setDropOffType(3);
        }
        if (trip.getShapeId() == null) {
            LOGGER.trace("skipping distance travelled for trip {}", (Object)trip.getId());
        } else {
            stopTime.setShapeDistTraveled(gtfsShape.getDistanceTravelledToStop(stopSequence));
        }
        return stopTime;
    }
}

