/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.gtfs.export.producer;

import org.entur.netex.gtfs.export.producer.AgencyProducer;
import org.entur.netex.gtfs.export.repository.NetexDatasetRepository;
import org.onebusaway.gtfs.model.Agency;
import org.rutebanken.netex.model.Authority;
import org.rutebanken.netex.model.ContactStructure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAgencyProducer
implements AgencyProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAgencyProducer.class);
    private final NetexDatasetRepository netexDatasetRepository;

    public DefaultAgencyProducer(NetexDatasetRepository netexDatasetRepository) {
        this.netexDatasetRepository = netexDatasetRepository;
    }

    @Override
    public Agency produce(Authority authority) {
        String timeZone = this.netexDatasetRepository.getTimeZone();
        Agency agency = new Agency();
        agency.setId(authority.getId());
        agency.setName(authority.getName().getValue());
        ContactStructure contactDetails = authority.getContactDetails();
        if (contactDetails != null) {
            String url = contactDetails.getUrl();
            if (url != null && !url.isBlank()) {
                if (DefaultAgencyProducer.isValidGtfsUrl(url)) {
                    agency.setUrl(url);
                } else {
                    LOGGER.warn("Invalid URL format {} for authority {}", (Object)url, (Object)authority.getId());
                }
            } else {
                LOGGER.warn("Missing URL for authority {}", (Object)authority.getId());
            }
            agency.setPhone(contactDetails.getPhone());
        } else {
            LOGGER.warn("Missing Contact details for authority {}", (Object)authority.getId());
        }
        agency.setTimezone(timeZone);
        return agency;
    }

    private static boolean isValidGtfsUrl(String url) {
        return url.startsWith("http://") || url.startsWith("https://");
    }
}

