/*
 * Decompiled with CFR 0.152.
 */
package org.entur.netex.gtfs.export.model;

import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Set;
import org.onebusaway.gtfs.model.calendar.ServiceDate;

public class ServiceCalendarPeriod {
    private final ServiceDate startDate;
    private final ServiceDate endDate;
    private final Set<DayOfWeek> daysOfWeek;

    public ServiceCalendarPeriod(LocalDateTime startDateTime, LocalDateTime endDateTime, Set<DayOfWeek> daysOfWeek) {
        this.startDate = new ServiceDate(ServiceCalendarPeriod.toGtfsDate(startDateTime));
        this.endDate = new ServiceDate(ServiceCalendarPeriod.toGtfsDate(endDateTime));
        this.daysOfWeek = daysOfWeek;
    }

    public ServiceDate getStartDate() {
        return this.startDate;
    }

    public ServiceDate getEndDate() {
        return this.endDate;
    }

    public Set<DayOfWeek> getDaysOfWeek() {
        return this.daysOfWeek;
    }

    private static Date toGtfsDate(LocalDateTime netexDate) {
        return Date.from(netexDate.atZone(ZoneId.systemDefault()).toInstant());
    }
}

